/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Locale;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.annotation.XmlTransient;
import org.nhindirect.common.cert.Thumbprint;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.CertificateException;
import org.nhindirect.config.store.TrustBundle;

@Entity
@Table(name="trustbundleanchor")
public class TrustBundleAnchor {
    private long id;
    private TrustBundle trustBundle;
    private byte[] anchorData;
    private String thumbprint;
    private Calendar validStartDate;
    private Calendar validEndDate;

    @Id
    @Column(name="id", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Column(name="thumbprint", nullable=false)
    public String getThumbprint() {
        return this.thumbprint;
    }

    public void setThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @JoinColumn(name="trustBundleId")
    @XmlTransient
    public TrustBundle getTrustBundle() {
        return this.trustBundle;
    }

    public void setTrustBundle(TrustBundle trustBundle) {
        this.trustBundle = trustBundle;
    }

    @Column(name="anchorData", length=4096, nullable=false)
    @Lob
    public byte[] getData() {
        return this.anchorData;
    }

    public void setData(byte[] data) throws CertificateException {
        this.anchorData = data;
        if (data == Certificate.NULL_CERT) {
            this.setThumbprint("");
        } else {
            this.loadCertFromData();
        }
    }

    @Column(name="validStartDate", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getValidStartDate() {
        return this.validStartDate;
    }

    public void setValidStartDate(Calendar validStartDate) {
        this.validStartDate = validStartDate;
    }

    @Column(name="validEndDate", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getValidEndDate() {
        return this.validEndDate;
    }

    public void setValidEndDate(Calendar validEndDate) {
        this.validEndDate = validEndDate;
    }

    private X509Certificate loadCertFromData() throws CertificateException {
        X509Certificate cert = null;
        try {
            this.validate();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.anchorData);
            cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            this.setThumbprint(Thumbprint.toThumbprint((X509Certificate)cert).toString());
            Calendar calEndTime = Calendar.getInstance(Locale.getDefault());
            calEndTime.setTime(cert.getNotAfter());
            Calendar calStartTime = Calendar.getInstance(Locale.getDefault());
            calStartTime.setTime(cert.getNotBefore());
            this.setValidEndDate(calEndTime);
            this.setValidStartDate(calStartTime);
            bais.close();
        }
        catch (Exception e) {
            this.setData(Certificate.NULL_CERT);
            throw new CertificateException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return cert;
    }

    public X509Certificate toCertificate() throws CertificateException {
        X509Certificate cert = null;
        try {
            this.validate();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.anchorData);
            cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            bais.close();
        }
        catch (Exception e) {
            throw new CertificateException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return cert;
    }

    private boolean hasData() {
        return this.anchorData != null && !this.anchorData.equals(Certificate.NULL_CERT);
    }

    public void validate() throws CertificateException {
        if (!this.hasData()) {
            throw new CertificateException("Invalid Certificate: no certificate data exists");
        }
    }
}

