/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store.util;

import java.security.cert.X509Certificate;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.config.model.exceptions.CertificateConversionException;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.CertificateException;
import org.nhindirect.config.store.EntityStatus;

public class CertificateUtils {
    private static final Log log = LogFactory.getLog(CertificateUtils.class);

    public static Certificate stripP12Protection(Certificate cert, KeyStoreProtectionManager kspMgr) {
        log.debug((Object)("Attempting to strip p12 protection for certificate with id " + cert.getId()));
        if (cert.isPrivateKey() && kspMgr != null) {
            log.debug((Object)"isPrivateKey = true ");
            char[] emptyProtection = "".toCharArray();
            try {
                log.debug((Object)"Attempting to convert to a container that is wrapped");
                if (CertUtils.toCertContainer((byte[])cert.getData()) != null) {
                    return cert;
                }
            }
            catch (CertificateConversionException e) {
                log.trace((Object)"CertificateConversionException error when converting wrapped data.", (Throwable)e);
            }
            catch (Throwable t) {
                log.debug((Object)"Throwable error when converting wrapped data.", t);
            }
            log.debug((Object)"Appears to not be wrapped.  Attempting to convert by changing p12 protection.");
            try {
                String oldKeystorePassPhrase = new String(kspMgr.getKeyStoreProtectionKey().getEncoded());
                String oldPrivateKeyPassPhrase = new String(kspMgr.getKeyStoreProtectionKey().getEncoded());
                byte[] data = CertUtils.changePkcs12Protection((byte[])cert.getData(), (char[])oldKeystorePassPhrase.toCharArray(), (char[])oldPrivateKeyPassPhrase.toCharArray(), (char[])emptyProtection, (char[])emptyProtection);
                cert.setData(data);
            }
            catch (Exception e) {
                throw new RuntimeException("Error stripping P12 protection data", e);
            }
        }
        return cert;
    }

    public static Certificate applyCertRepositoryAttributes(Certificate cert, KeyStoreProtectionManager kspMgr) {
        block9: {
            try {
                CertUtils.CertContainer container = null;
                X509Certificate xcert = null;
                try {
                    container = CertUtils.toCertContainer((byte[])cert.getData());
                    xcert = container.getCert();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (cert.getValidStartDate() == null && xcert != null) {
                    Calendar startDate = Calendar.getInstance();
                    startDate.setTime(xcert.getNotBefore());
                    cert.setValidStartDate(startDate);
                }
                if (cert.getValidEndDate() == null && xcert != null) {
                    Calendar endDate = Calendar.getInstance();
                    endDate.setTime(xcert.getNotAfter());
                    cert.setValidEndDate(endDate);
                }
                if (cert.getStatus() == null) {
                    cert.setStatus(EntityStatus.NEW);
                }
                cert.setPrivateKey(container != null && (container.getKey() != null || container.getWrappedKeyData() != null));
                if (!cert.isPrivateKey() || kspMgr == null || container.getKey() == null) break block9;
                try {
                    String newKeystorePassPhrase = new String(kspMgr.getKeyStoreProtectionKey().getEncoded());
                    String newPrivateKeyPassPhrase = new String(kspMgr.getPrivateKeyProtectionKey().getEncoded());
                    cert.setRawData(CertUtils.changePkcs12Protection((byte[])cert.getData(), (char[])"".toCharArray(), (char[])"".toCharArray(), (char[])newKeystorePassPhrase.toCharArray(), (char[])newPrivateKeyPassPhrase.toCharArray()));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error converting P12 to encrypted/protected format", e);
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return cert;
    }
}

