/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store.util;

import java.io.IOException;
import java.net.InetAddress;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.DNSRecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SRVRecord;

public class DNSRecordUtils {
    public static DNSRecord createARecord(String name, long ttl, String ip) throws ConfigurationStoreException {
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        try {
            ARecord rec = new ARecord(Name.fromString((String)name), 1, ttl, InetAddress.getByName(ip));
            return DNSRecord.fromWire(rec.toWireCanonical());
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to create DNS A record: " + e.getMessage(), e);
        }
    }

    public static DNSRecord createSRVRecord(String name, String target, long ttl, int port, int priority, int weight) throws ConfigurationStoreException {
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        if (!target.endsWith(".")) {
            target = target + ".";
        }
        try {
            SRVRecord rec = new SRVRecord(Name.fromString((String)name), 1, ttl, priority, weight, port, Name.fromString((String)target));
            return DNSRecord.fromWire(rec.toWireCanonical());
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to create DNS SRV record: " + e.getMessage(), e);
        }
    }

    public static DNSRecord createX509CERTRecord(String address, long ttl, X509Certificate cert) throws ConfigurationStoreException {
        if (!address.endsWith(".")) {
            address = address + ".";
        }
        try {
            int keyTag = 0;
            if (cert.getPublicKey() instanceof RSAKey) {
                RSAKey key = (RSAKey)((Object)cert.getPublicKey());
                byte[] modulus = key.getModulus().toByteArray();
                keyTag = modulus[modulus.length - 2] << 8 & 0xFF00;
                keyTag |= modulus[modulus.length - 1] & 0xFF;
            }
            CERTRecord rec = new CERTRecord(Name.fromString((String)address), 1, ttl, 1, keyTag, 5, cert.getEncoded());
            return DNSRecord.fromWire(rec.toWireCanonical());
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to create DNS CERT record: " + e.getMessage(), e);
        }
    }

    public static DNSRecord createMXRecord(String name, String target, long ttl, int priority) throws ConfigurationStoreException {
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        if (!target.endsWith(".")) {
            target = target + ".";
        }
        try {
            MXRecord rec = new MXRecord(Name.fromString((String)name), 1, ttl, priority, Name.fromString((String)target));
            return DNSRecord.fromWire(rec.toWireCanonical());
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to create DNS MX record: " + e.getMessage(), e);
        }
    }

    public static DNSRecord createSOARecord(String name, long ttl, String nameServer, String hostMaster, int serial, long refresh, long retry, long expire, long minumum) {
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        if (!nameServer.endsWith(".")) {
            nameServer = nameServer + ".";
        }
        if (!hostMaster.endsWith(".")) {
            hostMaster = hostMaster + ".";
        }
        try {
            SOARecord rec = new SOARecord(Name.fromString((String)name), 1, ttl, Name.fromString((String)nameServer), Name.fromString((String)hostMaster), (long)serial, refresh, retry, expire, minumum);
            return DNSRecord.fromWire(rec.toWireCanonical());
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to create DNS MX record: " + e.getMessage(), e);
        }
    }

    public static byte[] toWire(DNSRecord rec) throws IOException {
        Record retVal = Record.newRecord((Name)Name.fromString((String)rec.getName()), (int)rec.getType(), (int)rec.getDclass(), (long)rec.getTtl(), (byte[])rec.getData());
        return retVal.toWireCanonical();
    }

    public static DNSRecord fromWire(byte[] data) throws IOException {
        Record rec = Record.fromWire((byte[])data, (int)1);
        DNSRecord retVal = new DNSRecord();
        retVal.setDclass(rec.getDClass());
        retVal.setName(rec.getName().toString());
        retVal.setData(rec.rdataToWireCanonical());
        retVal.setTtl(rec.getTTL());
        retVal.setType(rec.getType());
        return retVal;
    }
}

