/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nhindirect.config.SpringBaseTest;
import org.nhindirect.config.repository.AnchorRepository;
import org.nhindirect.config.store.Anchor;
import org.nhindirect.config.store.EntityStatus;
import org.springframework.beans.factory.annotation.Autowired;

public class AnchorRepositoryTest
extends SpringBaseTest {
    private static final String certBasePath = "src/test/resources/certs/";
    private static final String TEST_DOMAIN = "TestDomain1";
    @Autowired
    private AnchorRepository repo;

    private void addTestAnchors() throws Exception {
        Anchor anchor = new Anchor();
        anchor.setData(AnchorRepositoryTest.loadCertificateData("secureHealthEmailCACert.der"));
        anchor.setOwner(TEST_DOMAIN);
        anchor.setOutgoing(true);
        anchor.setIncoming(true);
        this.repo.save((Object)anchor);
        anchor = new Anchor();
        anchor.setData(AnchorRepositoryTest.loadCertificateData("cacert.der"));
        anchor.setOwner(TEST_DOMAIN);
        anchor.setOutgoing(true);
        anchor.setIncoming(true);
        this.repo.save((Object)anchor);
    }

    private static byte[] loadCertificateData(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        return FileUtils.readFileToByteArray((File)fl);
    }

    @Before
    public void cleanDataBase() {
        this.repo.deleteAll();
    }

    @Test
    public void testCleanDatabase() throws Exception {
        List anchors = this.repo.findAll();
        Assert.assertEquals((long)0L, (long)anchors.size());
    }

    @Test
    public void testDeleteByIds() throws Exception {
        this.addTestAnchors();
        List anchors = this.repo.findAll();
        Assert.assertNotNull((Object)anchors);
        Assert.assertTrue((anchors.size() > 0 ? 1 : 0) != 0);
        for (Anchor anchorToDel : anchors) {
            this.repo.deleteById((Object)anchorToDel.getId());
        }
        anchors = this.repo.findAll();
        Assert.assertEquals((long)0L, (long)anchors.size());
    }

    @Test
    public void testAddAnchor() throws Exception {
        this.addTestAnchors();
        List anchors = this.repo.findAll();
        Assert.assertNotNull((Object)anchors);
        Assert.assertEquals((long)2L, (long)anchors.size());
        Anchor retAnchor = (Anchor)anchors.get(0);
        Assert.assertEquals((Object)retAnchor.getOwner(), (Object)TEST_DOMAIN);
    }

    @Test
    public void testGetByOwner() throws Exception {
        this.testCleanDatabase();
        this.addTestAnchors();
        ArrayList<String> owners = new ArrayList<String>();
        owners.add(TEST_DOMAIN.toUpperCase());
        List anchors = this.repo.findByOwnerInIgnoreCase(owners);
        Assert.assertNotNull((Object)anchors);
        Assert.assertEquals((long)2L, (long)anchors.size());
        for (Anchor retAnchor : anchors) {
            Assert.assertEquals((Object)retAnchor.getOwner(), (Object)TEST_DOMAIN);
        }
    }

    @Test
    public void testUpdateByIds() throws Exception {
        this.addTestAnchors();
        List anchors = this.repo.findAll();
        Assert.assertEquals((long)2L, (long)anchors.size());
        for (Anchor anchor : anchors) {
            anchor.setStatus(EntityStatus.ENABLED);
        }
        this.repo.saveAll((Iterable)anchors);
        anchors = this.repo.findAll();
        Assert.assertEquals((long)2L, (long)anchors.size());
        for (Anchor anchor : anchors) {
            Assert.assertEquals((Object)EntityStatus.ENABLED, (Object)anchor.getStatus());
            Assert.assertEquals((Object)TEST_DOMAIN, (Object)anchor.getOwner());
        }
    }

    @Test
    public void testUpdateByOwner() throws Exception {
        this.addTestAnchors();
        List anchors = this.repo.findByOwnerIgnoreCase(TEST_DOMAIN.toUpperCase());
        Assert.assertEquals((long)2L, (long)anchors.size());
        for (Anchor anchor : anchors) {
            anchor.setStatus(EntityStatus.ENABLED);
        }
        this.repo.saveAll((Iterable)anchors);
        anchors = this.repo.findAll();
        Assert.assertEquals((long)2L, (long)anchors.size());
        for (Anchor anchor : anchors) {
            Assert.assertEquals((Object)EntityStatus.ENABLED, (Object)anchor.getStatus());
            Assert.assertEquals((Object)TEST_DOMAIN, (Object)anchor.getOwner());
        }
    }
}

