/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.CertPolicyGroupDomainReltn;
import org.nhindirect.config.store.Domain;

public class CertPolicyGroupDomainReltnRepository_getPolicyGroupDomainReltnsTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicyGroupsDomainReltns_emptyReltnStore_assertNoReltnsRetrieved() {
        List groups = this.reltnRepo.findAll();
        Assert.assertTrue((boolean)groups.isEmpty());
    }

    @Test
    public void testGetPolicyGroupsDomainReltns_singleEntryInReltns_assertReltnRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        domain = (Domain)this.dmRepo.save((Object)domain);
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        group = (CertPolicyGroup)this.groupRepo.save((Object)group);
        CertPolicyGroupDomainReltn reltn = new CertPolicyGroupDomainReltn();
        reltn.setCertPolicyGroup(group);
        reltn.setDomain(domain);
        this.reltnRepo.save((Object)reltn);
        List reltns = this.reltnRepo.findAll();
        Assert.assertEquals((long)1L, (long)reltns.size());
        reltn = (CertPolicyGroupDomainReltn)reltns.iterator().next();
        Assert.assertEquals((Object)group.getPolicyGroupName(), (Object)reltn.getCertPolicyGroup().getPolicyGroupName());
        Assert.assertEquals((Object)domain.getDomainName(), (Object)reltn.getDomain().getDomainName());
    }

    @Test
    public void testGetPolicyGroupsDomainReltns_multipeEntriesReltns_assertReltnsRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        domain = (Domain)this.dmRepo.save((Object)domain);
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group 1");
        CertPolicyGroup group2 = new CertPolicyGroup();
        group2.setPolicyGroupName("Test Group 2");
        group1 = (CertPolicyGroup)this.groupRepo.save((Object)group1);
        group2 = (CertPolicyGroup)this.groupRepo.save((Object)group2);
        CertPolicyGroupDomainReltn reltn = new CertPolicyGroupDomainReltn();
        reltn.setCertPolicyGroup(group1);
        reltn.setDomain(domain);
        this.reltnRepo.save((Object)reltn);
        reltn = new CertPolicyGroupDomainReltn();
        reltn.setCertPolicyGroup(group2);
        reltn.setDomain(domain);
        this.reltnRepo.save((Object)reltn);
        List reltns = this.reltnRepo.findAll();
        Assert.assertEquals((long)2L, (long)reltns.size());
        Iterator iter = reltns.iterator();
        reltn = (CertPolicyGroupDomainReltn)iter.next();
        Assert.assertEquals((Object)group1.getPolicyGroupName(), (Object)reltn.getCertPolicyGroup().getPolicyGroupName());
        Assert.assertEquals((Object)domain.getDomainName(), (Object)reltn.getDomain().getDomainName());
        reltn = (CertPolicyGroupDomainReltn)iter.next();
        Assert.assertEquals((Object)group2.getPolicyGroupName(), (Object)reltn.getCertPolicyGroup().getPolicyGroupName());
        Assert.assertEquals((Object)domain.getDomainName(), (Object)reltn.getDomain().getDomainName());
    }
}

