/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Collection;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.CertPolicyGroupDomainReltn;
import org.nhindirect.config.store.Domain;

public class CertPolicyGroupDomainReltnRepository_getPolicyGroupsByDomainTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicyGroupsByDomain_associationsExist_assertPoliciesRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        domain = (Domain)this.dmRepo.save((Object)domain);
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        group = (CertPolicyGroup)this.groupRepo.save((Object)group);
        CertPolicyGroupDomainReltn reltn = new CertPolicyGroupDomainReltn();
        reltn.setCertPolicyGroup(group);
        reltn.setDomain(domain);
        this.reltnRepo.save((Object)reltn);
        Collection policies = this.reltnRepo.findByDomain(domain);
        Assert.assertEquals((long)1L, (long)policies.size());
    }

    @Test
    public void testGetPolicyGroupsByDomain_multipleAssociationsExist_assertPoliciesRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        domain = (Domain)this.dmRepo.save((Object)domain);
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group1");
        group1 = (CertPolicyGroup)this.groupRepo.save((Object)group1);
        CertPolicyGroup group2 = new CertPolicyGroup();
        group2.setPolicyGroupName("Test Group2");
        group2 = (CertPolicyGroup)this.groupRepo.save((Object)group2);
        CertPolicyGroupDomainReltn reltn = new CertPolicyGroupDomainReltn();
        reltn.setCertPolicyGroup(group1);
        reltn.setDomain(domain);
        this.reltnRepo.save((Object)reltn);
        reltn = new CertPolicyGroupDomainReltn();
        reltn.setCertPolicyGroup(group2);
        reltn.setDomain(domain);
        this.reltnRepo.save((Object)reltn);
        Collection policies = this.reltnRepo.findByDomain(domain);
        Assert.assertEquals((long)2L, (long)policies.size());
        Iterator polIter = policies.iterator();
        Assert.assertEquals((Object)group1.getPolicyGroupName(), (Object)((CertPolicyGroupDomainReltn)polIter.next()).getCertPolicyGroup().getPolicyGroupName());
        Assert.assertEquals((Object)group2.getPolicyGroupName(), (Object)((CertPolicyGroupDomainReltn)polIter.next()).getCertPolicyGroup().getPolicyGroupName());
    }

    @Test
    public void testGetPolicyGroupsByDomain_multipleAssociationsExist_oneToEachDomain_assertPoliciesRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain 1");
        domain1 = (Domain)this.dmRepo.save((Object)domain1);
        Domain domain2 = new Domain();
        domain2.setDomainName("Test Domain 2");
        domain2 = (Domain)this.dmRepo.save((Object)domain2);
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group1");
        group1 = (CertPolicyGroup)this.groupRepo.save((Object)group1);
        CertPolicyGroup group2 = new CertPolicyGroup();
        group2.setPolicyGroupName("Test Group2");
        group2 = (CertPolicyGroup)this.groupRepo.save((Object)group2);
        CertPolicyGroupDomainReltn reltn = new CertPolicyGroupDomainReltn();
        reltn.setCertPolicyGroup(group1);
        reltn.setDomain(domain1);
        this.reltnRepo.save((Object)reltn);
        reltn = new CertPolicyGroupDomainReltn();
        reltn.setCertPolicyGroup(group2);
        reltn.setDomain(domain2);
        this.reltnRepo.save((Object)reltn);
        Collection policies = this.reltnRepo.findByDomain(domain1);
        Assert.assertEquals((long)1L, (long)policies.size());
        Iterator polIter = policies.iterator();
        Assert.assertEquals((Object)group1.getPolicyGroupName(), (Object)((CertPolicyGroupDomainReltn)polIter.next()).getCertPolicyGroup().getPolicyGroupName());
        policies = this.reltnRepo.findByDomain(domain2);
        Assert.assertEquals((long)1L, (long)policies.size());
        polIter = policies.iterator();
        Assert.assertEquals((Object)group2.getPolicyGroupName(), (Object)((CertPolicyGroupDomainReltn)polIter.next()).getCertPolicyGroup().getPolicyGroupName());
    }

    @Test
    public void testGetPolicyGroupsByDomain_multipleAssociationsExist_policyToMultipeDomains_assertPoliciesRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain 1");
        domain1 = (Domain)this.dmRepo.save((Object)domain1);
        Domain domain2 = new Domain();
        domain2.setDomainName("Test Domain 2");
        domain2 = (Domain)this.dmRepo.save((Object)domain2);
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group1");
        group1 = (CertPolicyGroup)this.groupRepo.save((Object)group1);
        CertPolicyGroupDomainReltn reltn = new CertPolicyGroupDomainReltn();
        reltn.setCertPolicyGroup(group1);
        reltn.setDomain(domain1);
        this.reltnRepo.save((Object)reltn);
        reltn = new CertPolicyGroupDomainReltn();
        reltn.setCertPolicyGroup(group1);
        reltn.setDomain(domain2);
        this.reltnRepo.save((Object)reltn);
        Collection policies = this.reltnRepo.findByDomain(domain1);
        Assert.assertEquals((long)1L, (long)policies.size());
        Iterator polIter = policies.iterator();
        Assert.assertEquals((Object)group1.getPolicyGroupName(), (Object)((CertPolicyGroupDomainReltn)polIter.next()).getCertPolicyGroup().getPolicyGroupName());
        policies = this.reltnRepo.findByDomain(domain2);
        Assert.assertEquals((long)1L, (long)policies.size());
        polIter = policies.iterator();
        Assert.assertEquals((Object)group1.getPolicyGroupName(), (Object)((CertPolicyGroupDomainReltn)polIter.next()).getCertPolicyGroup().getPolicyGroupName());
    }

    @Test
    public void testGetPolicyGroupsByDomain_noPoliciesInDomain_assertPoliciesNotRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain 1");
        domain1 = (Domain)this.dmRepo.save((Object)domain1);
        Collection policies = this.reltnRepo.findByDomain(domain1);
        Assert.assertEquals((long)0L, (long)policies.size());
    }
}

