/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.springframework.dao.DataIntegrityViolationException;

public class CertPolicyGroupRepository_addPolicyGroupTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testAddPolicyGroup_addPolicyGroup_assertAdded() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.groupRepo.save((Object)group);
        List groups = this.groupRepo.findAll();
        Assert.assertEquals((long)1L, (long)groups.size());
        CertPolicyGroup addedGroup = (CertPolicyGroup)groups.iterator().next();
        Assert.assertEquals((Object)group.getPolicyGroupName(), (Object)addedGroup.getPolicyGroupName());
        Assert.assertTrue((now.getTimeInMillis() <= addedGroup.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
    }

    @Test(expected=DataIntegrityViolationException.class)
    public void testAddPolicyGroup_addExistingPolicy_assertException() {
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.groupRepo.save((Object)group);
        List groups = this.groupRepo.findAll();
        Assert.assertEquals((long)1L, (long)groups.size());
        group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.groupRepo.save((Object)group);
    }
}

