/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Calendar;
import java.util.Locale;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;

public class CertPolicyGroupRepository_getPolicyGroupByIdTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicyGroupById_emptyStore_assertNoPolicyGroupReturned() {
        Assert.assertEquals(Optional.empty(), (Object)this.groupRepo.findById((Object)1234L));
    }

    @Test
    public void testGetPolicyGroupById_singlePolicyGroupInStore_idNotInStore_assertNoPolicyGroupReturned() {
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.groupRepo.save((Object)group);
        Assert.assertEquals(Optional.empty(), (Object)this.groupRepo.findById((Object)1234L));
    }

    @Test
    public void testGetPolicyGroupById_singlePolicyGroupInStore_assertPolicyGroupReturned() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.groupRepo.save((Object)group);
        CertPolicyGroup addedGroup = (CertPolicyGroup)this.groupRepo.findById((Object)group.getId()).get();
        Assert.assertEquals((Object)group.getPolicyGroupName(), (Object)addedGroup.getPolicyGroupName());
        Assert.assertTrue((now.getTimeInMillis() <= addedGroup.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
    }
}

