/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;

public class CertPolicyGroupRepository_getPolicyGroupsTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicies_emptyPolicyGroupStore_assertNoPolicGroupsRetrieved() {
        List groups = this.groupRepo.findAll();
        Assert.assertTrue((boolean)groups.isEmpty());
    }

    @Test
    public void testGetPolicies_singleEntryInPolicyGroupStore_assertPolicyGroupRetrieved() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.groupRepo.save((Object)group);
        List groups = this.groupRepo.findAll();
        Assert.assertEquals((long)1L, (long)groups.size());
        CertPolicyGroup addedGroup = (CertPolicyGroup)groups.iterator().next();
        Assert.assertEquals((Object)group.getPolicyGroupName(), (Object)addedGroup.getPolicyGroupName());
        Assert.assertTrue((now.getTimeInMillis() <= addedGroup.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testGetPolicies_multipeEntriesInPolicyGroupStore_assertPolicyGroupsRetrieved() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group1");
        this.groupRepo.save((Object)group1);
        CertPolicyGroup group2 = new CertPolicyGroup();
        group2.setPolicyGroupName("Test Group2");
        this.groupRepo.save((Object)group2);
        List groups = this.groupRepo.findAll();
        Assert.assertEquals((long)2L, (long)groups.size());
        Iterator iter = groups.iterator();
        CertPolicyGroup addedGroup = (CertPolicyGroup)iter.next();
        Assert.assertEquals((Object)group1.getPolicyGroupName(), (Object)addedGroup.getPolicyGroupName());
        Assert.assertTrue((now.getTimeInMillis() <= addedGroup.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        addedGroup = (CertPolicyGroup)iter.next();
        Assert.assertEquals((Object)group2.getPolicyGroupName(), (Object)addedGroup.getPolicyGroupName());
        Assert.assertTrue((now.getTimeInMillis() <= addedGroup.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
    }
}

