/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.policy.PolicyLexicon;
import org.springframework.dao.DataIntegrityViolationException;

public class CertPolicyRepository_addPolicyTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testAddPolicy_addPolicy_assertAdded() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polRepo.save((Object)policy);
        List policies = this.polRepo.findAll();
        Assert.assertEquals((long)1L, (long)policies.size());
        CertPolicy addedPolicy = (CertPolicy)policies.iterator().next();
        Assert.assertEquals((Object)policy.getPolicyName(), (Object)addedPolicy.getPolicyName());
        Assert.assertEquals((Object)policy.getLexicon(), (Object)addedPolicy.getLexicon());
        Assert.assertTrue((now.getTimeInMillis() <= addedPolicy.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(policy.getPolicyData(), addedPolicy.getPolicyData()));
    }

    @Test(expected=DataIntegrityViolationException.class)
    public void testAddPolicy_addExistingPolicy_assertException() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polRepo.save((Object)policy);
        List policies = this.polRepo.findAll();
        Assert.assertEquals((long)1L, (long)policies.size());
        policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polRepo.save((Object)policy);
    }
}

