/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.policy.PolicyLexicon;

public class CertPolicyRepository_getPolicyByNameTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicyByName_emptyStore_assertNoPolicyReturned() {
        Assert.assertNull((Object)this.polRepo.findByPolicyNameIgnoreCase("Test Policy"));
    }

    @Test
    public void testGetPolicyByName_singlePolicyInStore_nameNotInStore_assertNoPolicyReturned() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test Policy");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polRepo.save((Object)policy);
        Assert.assertNull((Object)this.polRepo.findByPolicyNameIgnoreCase("Test Policy X"));
    }

    @Test
    public void testGetPolicyByName_singlePolicyInStore_assertPolicyReturned() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polRepo.save((Object)policy);
        CertPolicy addedPolicy = this.polRepo.findByPolicyNameIgnoreCase("Test POLicY");
        Assert.assertEquals((Object)policy.getPolicyName(), (Object)addedPolicy.getPolicyName());
        Assert.assertEquals((Object)policy.getLexicon(), (Object)addedPolicy.getLexicon());
        Assert.assertTrue((now.getTimeInMillis() <= addedPolicy.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(policy.getPolicyData(), addedPolicy.getPolicyData()));
    }
}

