/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.config.SpringBaseTest;
import org.nhindirect.config.repository.DNSRepository;
import org.nhindirect.config.store.DNSRecord;
import org.nhindirect.config.store.util.DNSRecordUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;

public class DNSRepositoryTest
extends SpringBaseTest {
    private static final String certBasePath = "src/test/resources/certs/";
    @Autowired
    private DNSRepository dnsRepo;

    private byte[] loadCertificateData(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        return FileUtils.readFileToByteArray((File)fl);
    }

    @Before
    public void cleanDataBase() {
        this.dnsRepo.deleteAll();
    }

    @Test
    public void testCleanDatabase() throws Exception {
        List records = this.dnsRepo.findAll();
        Assert.assertEquals((long)0L, (long)records.size());
    }

    @Test
    public void testAddCertRecord() throws Exception {
        byte[] certData = this.loadCertificateData("gm2552.der");
        Assert.assertNotNull((Object)certData);
        ByteArrayInputStream bais = new ByteArrayInputStream(certData);
        X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
        DNSRecord record1 = DNSRecordUtils.createX509CERTRecord((String)"gm2552@securehealthemail.com", (long)86400L, (X509Certificate)cert);
        this.dnsRepo.saveAll(Arrays.asList(record1));
        List records = this.dnsRepo.findByType(37);
        Assert.assertEquals((long)1L, (long)records.size());
        Assert.assertEquals((Object)record1, records.iterator().next());
    }

    @Test
    public void testAddSingleARecords() throws Exception {
        DNSRecord record = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        this.dnsRepo.saveAll(Arrays.asList(record));
        List records = this.dnsRepo.findByNameIgnoreCase(record.getName());
        Assert.assertEquals((long)1L, (long)records.size());
        DNSRecord compareRec = (DNSRecord)records.iterator().next();
        Assert.assertEquals((Object)record.getName(), (Object)compareRec.getName());
        Assert.assertEquals((long)1L, (long)compareRec.getType());
    }

    @Test
    public void testMultipleARecords() throws Exception {
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"74.22.43.123");
        DNSRecord record3 = DNSRecordUtils.createARecord((String)"sample.domain.com", (long)86400L, (String)"81.142.48.20");
        this.dnsRepo.saveAll(Arrays.asList(record1, record2, record3));
        List records = this.dnsRepo.findByNameIgnoreCase(record1.getName().toUpperCase());
        Assert.assertEquals((long)1L, (long)records.size());
        DNSRecord compareRec = (DNSRecord)records.iterator().next();
        Assert.assertEquals((Object)record1.getName(), (Object)compareRec.getName());
        Assert.assertEquals((long)1L, (long)compareRec.getType());
        records = this.dnsRepo.findAll();
        Assert.assertEquals((long)3L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record1));
        Assert.assertTrue((boolean)records.contains(record2));
        Assert.assertTrue((boolean)records.contains(record3));
        records = this.dnsRepo.findByType(1);
        Assert.assertEquals((long)3L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record1));
        Assert.assertTrue((boolean)records.contains(record2));
        Assert.assertTrue((boolean)records.contains(record3));
        records = this.dnsRepo.findByType(33);
        Assert.assertEquals((long)0L, (long)records.size());
    }

    @Test
    public void testAddRecord_invalidType() throws Exception {
    }

    @Test
    public void testAddRecord_recordAlreadyExistsWithRdata() throws Exception {
    }

    @Test
    public void testMultipleARecords_differentRdata() throws Exception {
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        this.dnsRepo.saveAll(Arrays.asList(record1));
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.2");
        this.dnsRepo.saveAll(Arrays.asList(record2));
        List records = this.dnsRepo.findByNameIgnoreCase(record1.getName());
        Assert.assertEquals((long)2L, (long)records.size());
        records.contains(record1);
        records.contains(record2);
    }

    @Test
    public void testGetByType() throws Exception {
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record3 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        this.dnsRepo.saveAll(Arrays.asList(record1, record2, record3));
        List records = this.dnsRepo.findByType(1);
        Assert.assertEquals((long)2L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record1));
        Assert.assertTrue((boolean)records.contains(record2));
        records = this.dnsRepo.findByType(33);
        Assert.assertEquals((long)1L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record3));
        records = this.dnsRepo.findAll();
        Assert.assertEquals((long)3L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record1));
        Assert.assertTrue((boolean)records.contains(record2));
        Assert.assertTrue((boolean)records.contains(record3));
    }

    @Test
    public void testGetByName() throws Exception {
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.2");
        DNSRecord record3 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"127.0.0.3");
        DNSRecord record4 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        DNSRecord record5 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example2.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        this.dnsRepo.saveAll(Arrays.asList(record1, record2, record3, record4, record5));
        List records = this.dnsRepo.findByNameIgnoreCase(record1.getName().toUpperCase());
        Assert.assertEquals((long)2L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record1));
        Assert.assertTrue((boolean)records.contains(record2));
        records = this.dnsRepo.findByNameIgnoreCase(record3.getName());
        Assert.assertEquals((long)1L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record3));
        records = this.dnsRepo.findByNameIgnoreCase(record4.getName());
        Assert.assertEquals((long)2L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record4));
        Assert.assertTrue((boolean)records.contains(record5));
        records = this.dnsRepo.findByNameIgnoreCase("bogus.com.");
        Assert.assertEquals((long)0L, (long)records.size());
    }

    @Test
    public void testGetByRecord() throws Exception {
        this.testCleanDatabase();
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.2");
        DNSRecord record3 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"127.0.0.3");
        DNSRecord record4 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        DNSRecord record5 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example2.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        this.dnsRepo.saveAll(Arrays.asList(record1, record2, record3, record4, record5));
        List records = this.dnsRepo.findByNameIgnoreCase(record3.getName());
        Assert.assertEquals((long)1L, (long)records.size());
        Optional checkRec = this.dnsRepo.findById((Object)((DNSRecord)records.iterator().next()).getId());
        Assert.assertNotNull((Object)checkRec);
        Assert.assertEquals(checkRec.get(), (Object)record3);
        records = this.dnsRepo.findAll();
        Assert.assertEquals((long)5L, (long)records.size());
        ArrayList<Long> ids = new ArrayList<Long>(records.size());
        for (DNSRecord record : records) {
            ids.add(record.getId());
        }
        records = this.dnsRepo.findAllById(ids);
        Assert.assertEquals((long)5L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record1));
        Assert.assertTrue((boolean)records.contains(record2));
        Assert.assertTrue((boolean)records.contains(record3));
        Assert.assertTrue((boolean)records.contains(record4));
        Assert.assertTrue((boolean)records.contains(record5));
    }

    @Test
    public void testGetCount() throws Exception {
        Assert.assertEquals((long)0L, (long)this.dnsRepo.count());
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.2");
        DNSRecord record3 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"127.0.0.3");
        DNSRecord record4 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        DNSRecord record5 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example2.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        this.dnsRepo.saveAll(Arrays.asList(record1, record2, record3, record4, record5));
        Assert.assertEquals((long)5L, (long)this.dnsRepo.count());
    }

    @Test
    public void testRemoveByRecords() throws Exception {
        Assert.assertEquals((long)0L, (long)this.dnsRepo.count());
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.2");
        DNSRecord record3 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"127.0.0.3");
        DNSRecord record4 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        DNSRecord record5 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example2.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        this.dnsRepo.saveAll(Arrays.asList(record1, record2, record3, record4, record5));
        Assert.assertEquals((long)5L, (long)this.dnsRepo.count());
        this.dnsRepo.deleteAll(Arrays.asList(record1, record2, record3));
        List records = this.dnsRepo.findAll();
        Assert.assertEquals((long)2L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record4));
        Assert.assertTrue((boolean)records.contains(record5));
        this.dnsRepo.deleteAll(Arrays.asList(record4, record5));
        records = this.dnsRepo.findAll();
        Assert.assertEquals((long)0L, (long)records.size());
    }

    @Test
    public void testRemoveByIds_noqualifying() throws Exception {
        Assert.assertEquals((long)0L, (long)this.dnsRepo.count());
        try {
            this.dnsRepo.deleteById((Object)876343L);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.dnsRepo.count());
    }

    @Test
    public void testRemoveByRecords_noqualifying() throws Exception {
        Assert.assertEquals((long)0L, (long)this.dnsRepo.count());
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        this.dnsRepo.delete((Object)record1);
        Assert.assertEquals((long)0L, (long)this.dnsRepo.count());
    }

    @Test
    public void testUpdateRecord() throws Exception {
        Assert.assertEquals((long)0L, (long)this.dnsRepo.count());
        DNSRecord record1 = DNSRecordUtils.createMXRecord((String)"example.domain.com", (String)"127.0.0.1", (long)86400L, (int)1);
        this.dnsRepo.saveAll(Arrays.asList(record1));
        List records = this.dnsRepo.findAll();
        Assert.assertEquals((long)1L, (long)records.size());
        DNSRecord checkRecord = (DNSRecord)records.iterator().next();
        Assert.assertEquals((Object)record1, (Object)checkRecord);
        checkRecord.setName("example2.domain.com.");
        this.dnsRepo.save((Object)checkRecord);
        records = this.dnsRepo.findAll();
        Assert.assertEquals((long)1L, (long)records.size());
        DNSRecord modRecord = (DNSRecord)records.iterator().next();
        Assert.assertEquals((Object)checkRecord, (Object)modRecord);
    }

    @Test
    public void testUpdateRecord_recordDoesNotExist() throws Exception {
    }

    @Test
    public void testUpdateRecord_illegalAnyType() throws Exception {
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

