/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nhindirect.config.SpringBaseTest;
import org.nhindirect.config.repository.AddressRepository;
import org.nhindirect.config.repository.DomainRepository;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.EntityStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DomainRepositoryTest
extends SpringBaseTest {
    private static final Log log = LogFactory.getLog(DomainRepositoryTest.class);
    @Autowired
    private DomainRepository domRepo;
    @Autowired
    private AddressRepository addRepo;

    @Before
    public void cleanDataBase() {
        this.addRepo.deleteAll();
        this.domRepo.deleteAll();
    }

    @Test
    public void testCleanDatabase() {
        Assert.assertEquals((long)0L, (long)this.addRepo.findAll().size());
        Assert.assertEquals((long)0L, (long)this.domRepo.findAll().size());
    }

    @Test
    public void testAddDomain() {
        Domain domain = new Domain("health.testdomain.com");
        domain.setStatus(EntityStatus.ENABLED);
        this.domRepo.save((Object)domain);
        Assert.assertEquals((long)this.domRepo.count(), (long)1L);
    }

    @Test
    public void testGetByDomain() {
        Domain domain = new Domain("health.testdomain.com");
        domain.setStatus(EntityStatus.ENABLED);
        this.domRepo.save((Object)domain);
        Domain testDomain = this.domRepo.findByDomainNameIgnoreCase("health.testdomain.com");
        log.info((Object)("Newly added Domain ID is: " + testDomain.getId()));
        log.info((Object)("Newly added Domain Status is: " + testDomain.getStatus()));
        Assert.assertTrue((boolean)testDomain.getDomainName().equals("health.testdomain.com"));
    }

    @Test
    public void testUpdateDomain() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SS Z");
        Domain domain = new Domain("health.testdomain.com");
        domain.setStatus(EntityStatus.ENABLED);
        this.domRepo.save((Object)domain);
        Domain testDomain = this.domRepo.findByDomainNameIgnoreCase("health.testdomain.cOM");
        log.info((Object)("Newly added Domain ID is: " + testDomain.getId()));
        log.info((Object)("Newly added Domain Status is: " + testDomain.getStatus()));
        log.info((Object)("Newly added Domain Update Time is: " + fmt.format(new Date(testDomain.getUpdateTime().getTimeInMillis()))));
        Assert.assertTrue((boolean)testDomain.getDomainName().equals("health.testdomain.com"));
        testDomain.setStatus(EntityStatus.DISABLED);
        this.domRepo.save((Object)testDomain);
        domain = this.domRepo.findByDomainNameIgnoreCase("health.testdomain.com");
        log.info((Object)("Updated Domain ID is: " + domain.getId()));
        log.info((Object)("Updated Status is: " + domain.getStatus()));
        log.info((Object)("Updated Update Time is: " + fmt.format(new Date(domain.getUpdateTime().getTimeInMillis()))));
        Assert.assertTrue((boolean)domain.getStatus().equals((Object)EntityStatus.DISABLED));
    }

    @Test
    public void testGetDomain() {
        Domain domain = new Domain("health.testdomain.com");
        domain.setStatus(EntityStatus.NEW);
        this.domRepo.save((Object)domain);
        domain = new Domain("health.newdomain.com");
        domain.setStatus(EntityStatus.NEW);
        this.domRepo.save((Object)domain);
        ArrayList<String> names = new ArrayList<String>();
        names.add("health.testdomain.com".toUpperCase());
        Assert.assertEquals((long)this.domRepo.findByDomainNameInIgnoreCaseAndStatus(names, EntityStatus.NEW).size(), (long)1L);
        Assert.assertEquals((long)this.domRepo.findByStatus(EntityStatus.NEW).size(), (long)2L);
        Assert.assertEquals((long)this.domRepo.findByDomainNameInIgnoreCase(names).size(), (long)1L);
        Assert.assertEquals((long)this.domRepo.findByDomainNameInIgnoreCaseAndStatus(names, EntityStatus.ENABLED).size(), (long)0L);
        Assert.assertEquals((long)this.domRepo.findByDomainNameInIgnoreCaseAndStatus(names, EntityStatus.DISABLED).size(), (long)0L);
        Assert.assertEquals((long)this.domRepo.findAll().size(), (long)2L);
        names.clear();
        names.add("health.baddomain.com");
        Assert.assertEquals((long)0L, (long)this.domRepo.findByDomainNameInIgnoreCase(names).size());
    }

    @Test
    public void testDeleteDomain() {
        Domain domain = new Domain("health.newdomain.com");
        domain.setPostMasterEmail("postmaster@health.newdomain.com");
        domain.setStatus(EntityStatus.NEW);
        this.domRepo.save((Object)domain);
        Assert.assertEquals((long)1L, (long)this.domRepo.count());
        this.domRepo.deleteByDomainNameIgnoreCase("health.testdomain.cOM");
        Assert.assertEquals((long)1L, (long)this.domRepo.count());
        this.domRepo.deleteByDomainNameIgnoreCase("health.newdomain.com");
        Assert.assertEquals((long)0L, (long)this.domRepo.count());
    }

    @Test
    public void testSearchDomain() {
        log.debug((Object)"Enter");
        Domain domain = new Domain("health.newdomain.com");
        domain.setStatus(EntityStatus.NEW);
        this.domRepo.save((Object)domain);
        domain = new Domain("healthy.domain.com");
        domain.setStatus(EntityStatus.NEW);
        this.domRepo.save((Object)domain);
        String name = "heaL";
        List result = this.domRepo.findByDomainNameContainingIgnoreCase(name);
        Assert.assertEquals((long)2L, (long)result.size());
        name = "coM";
        result = this.domRepo.findByDomainNameContainingIgnoreCaseAndStatus(name, EntityStatus.NEW);
        Assert.assertEquals((long)2L, (long)result.size());
        name = "coM";
        result = this.domRepo.findByDomainNameContainingIgnoreCaseAndStatus(name, EntityStatus.DISABLED);
        Assert.assertEquals((long)0L, (long)result.size());
        log.debug((Object)"Exit");
    }

    @Test
    public void testAddDomainsWithAddresses() {
        Domain domain = new Domain("health.newdomain.com");
        domain.setStatus(EntityStatus.NEW);
        domain.getAddresses().add(new Address(domain, "test1@health.newdomain.com", "Test1"));
        domain.getAddresses().add(new Address(domain, "test2@health.newdomain.com", "Test2"));
        domain.getAddresses().add(new Address(domain, "postmaster@health.newdomain.com", "Test3"));
        this.domRepo.save((Object)domain);
        Domain getDomain = this.domRepo.findByDomainNameIgnoreCase("health.newdomain.com");
        Assert.assertEquals((long)3L, (long)getDomain.getAddresses().size());
        getDomain.setPostMasterEmail("postmaster@health.newdomain.com");
        this.domRepo.save((Object)getDomain);
        getDomain = this.domRepo.findByDomainNameIgnoreCase("health.newdomain.com");
        Assert.assertEquals((Object)"postmaster@health.newdomain.com", (Object)getDomain.getPostMasterEmail());
        Assert.assertEquals((long)3L, (long)getDomain.getAddresses().size());
        log.info((Object)domain.toString());
        log.info((Object)getDomain.toString());
        for (Address testAddress : getDomain.getAddresses()) {
            log.info((Object)testAddress.toString());
        }
    }

    @Test
    public void testDeleteDomainsWithAddresses() {
        Domain domain = new Domain("health.newdomain.com");
        domain.setStatus(EntityStatus.NEW);
        domain.getAddresses().add(new Address(domain, "test1@health.newdomain.com", "Test1"));
        domain.getAddresses().add(new Address(domain, "test2@health.newdomain.com", "Test2"));
        this.domRepo.save((Object)domain);
        Domain test = this.domRepo.findByDomainNameIgnoreCase("health.newdomain.com");
        Assert.assertEquals((long)2L, (long)test.getAddresses().size());
        this.domRepo.deleteByDomainNameIgnoreCase("health.newdomain.COM");
        test = this.domRepo.findByDomainNameIgnoreCase("health.newdomain.com");
        Assert.assertEquals(null, (Object)test);
        domain = new Domain("health.domain.com");
        domain.setStatus(EntityStatus.NEW);
        domain.getAddresses().add(new Address(domain, "test1@health.domain.com", "Test1"));
        domain.getAddresses().add(new Address(domain, "test2@health.domain.com", "Test2"));
        this.domRepo.save((Object)domain);
        test = this.domRepo.findByDomainNameIgnoreCase("health.domain.com");
        Long id = test.getId();
        this.domRepo.deleteById((Object)id);
        Assert.assertEquals(Optional.empty(), (Object)this.domRepo.findById((Object)id));
    }
}

