/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleDomainReltn;
import org.springframework.dao.DataIntegrityViolationException;

public class TrustBundleRepository_associateTrustBundleToDomainTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testAssociateTrustBundleToDomain_associateDomainAndBundle_assertAssociationAdded() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        domain = (Domain)this.dmRepo.save((Object)domain);
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://test/url/bundle");
        bundle.setCheckSum("1234");
        bundle = (TrustBundle)this.tbRepo.save((Object)bundle);
        TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
        reltn.setDomain(domain);
        reltn.setTrustBundle(bundle);
        reltn.setIncoming(true);
        reltn.setOutgoing(false);
        this.reltnRepo.save((Object)reltn);
        Collection bundleReltn = this.reltnRepo.findByDomain(domain);
        Assert.assertEquals((long)1L, (long)bundleReltn.size());
        reltn = (TrustBundleDomainReltn)bundleReltn.iterator().next();
        Assert.assertTrue((boolean)reltn.isIncoming());
        Assert.assertFalse((boolean)reltn.isOutgoing());
    }

    @Test(expected=DataIntegrityViolationException.class)
    public void testAssociateTrustBundleToDomain_unknownDomain_assertException() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        domain.setId(Long.valueOf(12345L));
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://test/url/bundle");
        bundle.setCheckSum("1234");
        bundle = (TrustBundle)this.tbRepo.save((Object)bundle);
        TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
        reltn.setDomain(domain);
        reltn.setTrustBundle(bundle);
        reltn.setIncoming(true);
        reltn.setOutgoing(false);
        this.reltnRepo.save((Object)reltn);
    }

    @Test(expected=DataIntegrityViolationException.class)
    public void testAssociateTrustBundleToDomain_unknownTrustBundle_assertException() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        domain = (Domain)this.dmRepo.save((Object)domain);
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://test/url/bundle");
        bundle.setCheckSum("1234");
        bundle.setId(12345L);
        TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
        reltn.setDomain(domain);
        reltn.setTrustBundle(bundle);
        reltn.setDomain(domain);
        reltn.setIncoming(true);
        reltn.setOutgoing(false);
        this.reltnRepo.save((Object)reltn);
    }
}

