/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.TrustBundle;

public class TrustBundleRepository_deleteTrustBundlesTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testDeleteTrustBundlesTest_singleBundle_assertBundleDeleted() {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(Calendar.getInstance());
        this.tbRepo.save((Object)bundle);
        List bundles = this.tbRepo.findAll();
        Assert.assertEquals((long)1L, (long)bundles.size());
        this.tbRepo.deleteAll((Iterable)bundles);
        bundles = this.tbRepo.findAll();
        Assert.assertEquals((long)0L, (long)bundles.size());
    }

    @Test
    public void testDeleteTrustBundlesTest_multipleBundles_assertSingleBundleDeleted() {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(Calendar.getInstance());
        this.tbRepo.save((Object)bundle);
        bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle2");
        bundle.setBundleURL("http://testBundle/bundle2.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("67890");
        bundle.setCreateTime(Calendar.getInstance());
        this.tbRepo.save((Object)bundle);
        List bundles = this.tbRepo.findAll();
        Assert.assertEquals((long)2L, (long)bundles.size());
        this.tbRepo.deleteById((Object)((TrustBundle)bundles.iterator().next()).getId());
        bundles = this.tbRepo.findAll();
        Assert.assertEquals((long)1L, (long)bundles.size());
    }

    @Test
    public void testDeleteTrustBundlesTest_multipleBundles_assertAllBundlesDeleted() {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(Calendar.getInstance());
        this.tbRepo.save((Object)bundle);
        bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle2");
        bundle.setBundleURL("http://testBundle/bundle2.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("67890");
        bundle.setCreateTime(Calendar.getInstance());
        this.tbRepo.save((Object)bundle);
        List bundles = this.tbRepo.findAll();
        Assert.assertEquals((long)2L, (long)bundles.size());
        Iterator iter = bundles.iterator();
        this.tbRepo.deleteAll(Arrays.asList((TrustBundle)iter.next(), (TrustBundle)iter.next()));
        bundles = this.tbRepo.findAll();
        Assert.assertEquals((long)0L, (long)bundles.size());
    }
}

