/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Calendar;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.TrustBundle;

public class TrustBundleRepository_getTrustBundleByNameTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testTetTrustBundleByName_emptyStore_assertNoBundleReturned() {
        Assert.assertNull((Object)this.tbRepo.findByBundleNameIgnoreCase("Test Bundle"));
    }

    @Test
    public void testTetTrustBundleByName_singleBundleInStore_nameNotInStore_assertNoBundleReturned() {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(Calendar.getInstance());
        this.tbRepo.save((Object)bundle);
        Assert.assertNull((Object)this.tbRepo.findByBundleNameIgnoreCase("Test Bundle X"));
    }

    @Test
    public void testTetTrustBundleByName_singleBundleInStore_assertBundleReturned() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(Calendar.getInstance());
        this.tbRepo.save((Object)bundle);
        TrustBundle addedBundle = this.tbRepo.findByBundleNameIgnoreCase("Test BundLE");
        Assert.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.getTimeInMillis() <= addedBundle.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertNull((Object)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
        Assert.assertTrue((boolean)addedBundle.getTrustBundleAnchors().isEmpty());
    }
}

