/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Collection;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleDomainReltn;

public class TrustBundleRepository_getTrustBundlesByDomainTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testGetTrustBundlesByDomain_associationsExist_assertBundlesRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        domain = (Domain)this.dmRepo.save((Object)domain);
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://test/url/bundle");
        bundle.setCheckSum("1234");
        bundle = (TrustBundle)this.tbRepo.save((Object)bundle);
        TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
        reltn.setDomain(domain);
        reltn.setTrustBundle(bundle);
        reltn.setIncoming(true);
        reltn.setOutgoing(true);
        this.reltnRepo.save((Object)reltn);
        Collection bundles = this.reltnRepo.findByDomain(domain);
        Assert.assertEquals((long)1L, (long)bundles.size());
    }

    @Test
    public void testGetTrustBundlesByDomain_multipleAssociationsExist_assertBundlesRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        domain = (Domain)this.dmRepo.save((Object)domain);
        TrustBundle bundle1 = new TrustBundle();
        bundle1.setBundleName("Test Bundle");
        bundle1.setBundleURL("http://test/url/bundle");
        bundle1.setCheckSum("1234");
        bundle1 = (TrustBundle)this.tbRepo.save((Object)bundle1);
        TrustBundle bundle2 = new TrustBundle();
        bundle2.setBundleName("Test Bundle2");
        bundle2.setBundleURL("http://test/url/bundle2");
        bundle2.setCheckSum("1234");
        bundle2 = (TrustBundle)this.tbRepo.save((Object)bundle2);
        TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
        reltn.setDomain(domain);
        reltn.setTrustBundle(bundle1);
        reltn.setIncoming(true);
        reltn.setOutgoing(true);
        this.reltnRepo.save((Object)reltn);
        reltn = new TrustBundleDomainReltn();
        reltn.setDomain(domain);
        reltn.setTrustBundle(bundle2);
        reltn.setIncoming(true);
        reltn.setOutgoing(true);
        this.reltnRepo.save((Object)reltn);
        Collection bundles = this.reltnRepo.findByDomain(domain);
        Assert.assertEquals((long)2L, (long)bundles.size());
        Iterator bundleIter = bundles.iterator();
        Assert.assertEquals((Object)bundle1.getBundleName(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundle().getBundleName());
        Assert.assertEquals((Object)bundle2.getBundleName(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundle().getBundleName());
    }

    @Test
    public void testGetTrustBundlesByDomain_multipleAssociationsExist_oneToEachDomain_assertBundlesRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain");
        domain1 = (Domain)this.dmRepo.save((Object)domain1);
        Domain domain2 = new Domain();
        domain2.setDomainName("Test Domain 2");
        domain2 = (Domain)this.dmRepo.save((Object)domain2);
        TrustBundle bundle1 = new TrustBundle();
        bundle1.setBundleName("Test Bundle");
        bundle1.setBundleURL("http://test/url/bundle");
        bundle1.setCheckSum("1234");
        bundle1 = (TrustBundle)this.tbRepo.save((Object)bundle1);
        TrustBundle bundle2 = new TrustBundle();
        bundle2.setBundleName("Test Bundle2");
        bundle2.setBundleURL("http://test/url/bundle2");
        bundle2.setCheckSum("1234");
        bundle2 = (TrustBundle)this.tbRepo.save((Object)bundle2);
        TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
        reltn.setDomain(domain1);
        reltn.setTrustBundle(bundle1);
        reltn.setIncoming(true);
        reltn.setOutgoing(true);
        this.reltnRepo.save((Object)reltn);
        reltn = new TrustBundleDomainReltn();
        reltn.setDomain(domain2);
        reltn.setTrustBundle(bundle2);
        reltn.setIncoming(true);
        reltn.setOutgoing(true);
        this.reltnRepo.save((Object)reltn);
        Collection bundles = this.reltnRepo.findByDomain(domain1);
        Assert.assertEquals((long)1L, (long)bundles.size());
        Iterator bundleIter = bundles.iterator();
        Assert.assertEquals((Object)bundle1.getBundleName(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundle().getBundleName());
        bundles = this.reltnRepo.findByDomain(domain2);
        Assert.assertEquals((long)1L, (long)bundles.size());
        bundleIter = bundles.iterator();
        Assert.assertEquals((Object)bundle2.getBundleName(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundle().getBundleName());
    }

    @Test
    public void testGetTrustBundlesByDomain_multipleAssociationsExist_bundleToMultipeDomains_assertBundlesRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain 1");
        domain1 = (Domain)this.dmRepo.save((Object)domain1);
        Domain domain2 = new Domain();
        domain2.setDomainName("Test Domain 2");
        domain2 = (Domain)this.dmRepo.save((Object)domain2);
        TrustBundle bundle1 = new TrustBundle();
        bundle1.setBundleName("Test Bundle1");
        bundle1.setBundleURL("http://test/url/bundle1");
        bundle1.setCheckSum("1234");
        bundle1 = (TrustBundle)this.tbRepo.save((Object)bundle1);
        TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
        reltn.setDomain(domain1);
        reltn.setTrustBundle(bundle1);
        reltn.setIncoming(true);
        reltn.setOutgoing(true);
        this.reltnRepo.save((Object)reltn);
        reltn = new TrustBundleDomainReltn();
        reltn.setDomain(domain2);
        reltn.setTrustBundle(bundle1);
        reltn.setIncoming(true);
        reltn.setOutgoing(true);
        this.reltnRepo.save((Object)reltn);
        Collection bundles = this.reltnRepo.findByDomain(domain1);
        Assert.assertEquals((long)1L, (long)bundles.size());
        Iterator bundleIter = bundles.iterator();
        Assert.assertEquals((Object)bundle1.getBundleName(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundle().getBundleName());
        bundles = this.reltnRepo.findByDomain(domain2);
        Assert.assertEquals((long)1L, (long)bundles.size());
        bundleIter = bundles.iterator();
        Assert.assertEquals((Object)bundle1.getBundleName(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundle().getBundleName());
    }

    @Test
    public void testGetTrustBundlesByDomain_noBundlesInDomain_assertBundlesNotRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain 1");
        domain1 = (Domain)this.dmRepo.save((Object)domain1);
        Collection bundles = this.reltnRepo.findByDomain(domain1);
        Assert.assertEquals((long)0L, (long)bundles.size());
    }
}

