/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;

public class TrustBundleRepository_updateTrustBundleAnchorsTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testUpdateTrustBundleAnchors_addNewAnchors_assertNewAnchors() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(Calendar.getInstance());
        this.tbRepo.save((Object)bundle);
        TrustBundleAnchor anchor = new TrustBundleAnchor();
        anchor.setData(TrustBundleRepository_updateTrustBundleAnchorsTest.loadCertificateData("secureHealthEmailCACert.der"));
        anchor.setTrustBundle(bundle);
        bundle.setTrustBundleAnchors(Arrays.asList(anchor));
        bundle.setCheckSum("6789");
        this.tbRepo.save((Object)bundle);
        TrustBundle addedBundle = (TrustBundle)this.tbRepo.findById((Object)bundle.getId()).get();
        Assert.assertEquals((long)1L, (long)addedBundle.getTrustBundleAnchors().size());
        TrustBundleAnchor addedAnchor = (TrustBundleAnchor)addedBundle.getTrustBundleAnchors().iterator().next();
        Assert.assertEquals((Object)anchor.toCertificate(), (Object)addedAnchor.toCertificate());
    }

    @Test
    public void testUpdateTrustBundleAnchors_addAdditionalAnchors_assertNewAnchors() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(Calendar.getInstance());
        TrustBundleAnchor anchor = new TrustBundleAnchor();
        anchor.setData(TrustBundleRepository_updateTrustBundleAnchorsTest.loadCertificateData("secureHealthEmailCACert.der"));
        anchor.setTrustBundle(bundle);
        bundle.setTrustBundleAnchors(Arrays.asList(anchor));
        this.tbRepo.save((Object)bundle);
        TrustBundleAnchor additionalAnchor = new TrustBundleAnchor();
        additionalAnchor.setData(TrustBundleRepository_updateTrustBundleAnchorsTest.loadCertificateData("umesh.der"));
        additionalAnchor.setTrustBundle(bundle);
        ArrayList<TrustBundleAnchor> newAnchors = new ArrayList<TrustBundleAnchor>(bundle.getTrustBundleAnchors());
        newAnchors.add(additionalAnchor);
        bundle.setTrustBundleAnchors(newAnchors);
        bundle.setCheckSum("6789");
        this.tbRepo.save((Object)bundle);
        TrustBundle addedBundle = (TrustBundle)this.tbRepo.findById((Object)bundle.getId()).get();
        Assert.assertEquals((Object)"6789", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)2L, (long)addedBundle.getTrustBundleAnchors().size());
        Iterator iter = addedBundle.getTrustBundleAnchors().iterator();
        TrustBundleAnchor addedAnchor = (TrustBundleAnchor)iter.next();
        Assert.assertEquals((Object)anchor.toCertificate(), (Object)addedAnchor.toCertificate());
        addedAnchor = (TrustBundleAnchor)iter.next();
        Assert.assertEquals((Object)additionalAnchor.toCertificate(), (Object)addedAnchor.toCertificate());
    }

    @Test
    public void testUpdateTrustBundleAnchors_addSwapAnchors_assertNewAnchors() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(Calendar.getInstance());
        TrustBundleAnchor anchor = new TrustBundleAnchor();
        anchor.setData(TrustBundleRepository_updateTrustBundleAnchorsTest.loadCertificateData("secureHealthEmailCACert.der"));
        anchor.setTrustBundle(bundle);
        bundle.setTrustBundleAnchors(Arrays.asList(anchor));
        this.tbRepo.save((Object)bundle);
        TrustBundle addedBundle = (TrustBundle)this.tbRepo.findById((Object)bundle.getId()).get();
        Assert.assertEquals((long)1L, (long)addedBundle.getTrustBundleAnchors().size());
        TrustBundleAnchor newAnchor = new TrustBundleAnchor();
        newAnchor.setData(TrustBundleRepository_updateTrustBundleAnchorsTest.loadCertificateData("umesh.der"));
        newAnchor.setTrustBundle(bundle);
        bundle.setTrustBundleAnchors(Arrays.asList(newAnchor));
        this.tbRepo.save((Object)bundle);
        addedBundle = (TrustBundle)this.tbRepo.findById((Object)bundle.getId()).get();
        Assert.assertEquals((long)1L, (long)addedBundle.getTrustBundleAnchors().size());
        TrustBundleAnchor addedAnchor = (TrustBundleAnchor)addedBundle.getTrustBundleAnchors().iterator().next();
        Assert.assertEquals((Object)newAnchor.toCertificate(), (Object)addedAnchor.toCertificate());
    }
}

