/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Calendar;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;

public class TrustBundleRepository_updateTrustBundleAttributesTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testTrustBundleAttributes_updateCert_assertCertUpdated() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(Calendar.getInstance());
        this.tbRepo.save((Object)bundle);
        TrustBundleAnchor anchor = new TrustBundleAnchor();
        anchor.setData(TrustBundleRepository_updateTrustBundleAttributesTest.loadCertificateData("secureHealthEmailCACert.der"));
        bundle.setSigningCertificateData(anchor.toCertificate().getEncoded());
        this.tbRepo.save((Object)bundle);
        TrustBundle updatedBundle = (TrustBundle)this.tbRepo.findById((Object)bundle.getId()).get();
        Assert.assertEquals((Object)bundle.getBundleName(), (Object)updatedBundle.getBundleName());
        Assert.assertEquals((Object)bundle.getBundleURL(), (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)bundle.getRefreshInterval(), (long)updatedBundle.getRefreshInterval());
        Assert.assertEquals((long)bundle.getTrustBundleAnchors().size(), (long)updatedBundle.getTrustBundleAnchors().size());
        Assert.assertEquals((Object)anchor.toCertificate(), (Object)updatedBundle.toSigningCertificate());
    }

    @Test
    public void testTrustBundleAttributes_updateCert_setNull_assertCertNull() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setSigningCertificateData(TrustBundleRepository_updateTrustBundleAttributesTest.loadCertificateData("secureHealthEmailCACert.der"));
        bundle.setCreateTime(Calendar.getInstance());
        this.tbRepo.save((Object)bundle);
        bundle.setSigningCertificateData(null);
        this.tbRepo.save((Object)bundle);
        TrustBundle updatedBundle = (TrustBundle)this.tbRepo.findById((Object)bundle.getId()).get();
        Assert.assertEquals((Object)bundle.getBundleName(), (Object)updatedBundle.getBundleName());
        Assert.assertEquals((Object)bundle.getBundleURL(), (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)bundle.getRefreshInterval(), (long)updatedBundle.getRefreshInterval());
        Assert.assertEquals((long)bundle.getTrustBundleAnchors().size(), (long)updatedBundle.getTrustBundleAnchors().size());
        Assert.assertNull((Object)updatedBundle.getSigningCertificateData());
    }

    @Test
    public void testUpdateTrustBundleSigningCertificate_updateBundleName_assertNameUpdate() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(Calendar.getInstance());
        this.tbRepo.save((Object)bundle);
        bundle.setBundleName("New Test Bundle Name");
        this.tbRepo.save((Object)bundle);
        TrustBundle updatedBundle = (TrustBundle)this.tbRepo.findById((Object)bundle.getId()).get();
        Assert.assertEquals((Object)"New Test Bundle Name", (Object)updatedBundle.getBundleName());
        Assert.assertEquals((Object)bundle.getBundleURL(), (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)bundle.getRefreshInterval(), (long)updatedBundle.getRefreshInterval());
        Assert.assertNull((Object)updatedBundle.getSigningCertificateData());
        Assert.assertEquals((long)bundle.getTrustBundleAnchors().size(), (long)updatedBundle.getTrustBundleAnchors().size());
    }

    @Test
    public void testUpdateTrustBundleSigningCertificate_updateBundleURL_assertURLUpdate() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(Calendar.getInstance());
        this.tbRepo.save((Object)bundle);
        bundle.setBundleURL("http://testBundle/bundle.p7b333");
        this.tbRepo.save((Object)bundle);
        TrustBundle updatedBundle = (TrustBundle)this.tbRepo.findById((Object)bundle.getId()).get();
        Assert.assertEquals((Object)bundle.getBundleName(), (Object)bundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b333", (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)bundle.getRefreshInterval(), (long)updatedBundle.getRefreshInterval());
        Assert.assertNull((Object)updatedBundle.getSigningCertificateData());
        Assert.assertEquals((long)bundle.getTrustBundleAnchors().size(), (long)updatedBundle.getTrustBundleAnchors().size());
    }

    @Test
    public void testUpdateTrustBundleSigningCertificate_updateBundleRefreshInterval_assertIntervalUpdate() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(Calendar.getInstance());
        this.tbRepo.save((Object)bundle);
        bundle.setRefreshInterval(7);
        this.tbRepo.save((Object)bundle);
        TrustBundle updatedBundle = (TrustBundle)this.tbRepo.findById((Object)bundle.getId()).get();
        Assert.assertEquals((Object)bundle.getBundleName(), (Object)updatedBundle.getBundleName());
        Assert.assertEquals((Object)bundle.getBundleURL(), (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)7L, (long)updatedBundle.getRefreshInterval());
        Assert.assertNull((Object)updatedBundle.getSigningCertificateData());
        Assert.assertEquals((long)bundle.getTrustBundleAnchors().size(), (long)updatedBundle.getTrustBundleAnchors().size());
    }
}

