/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.File;
import java.security.cert.X509Certificate;
import org.apache.commons.io.FileUtils;
import org.junit.Test;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.repository.CertificateRepositoryTest;
import org.nhindirect.config.store.Certificate;

public class Certfificate_setDataTest {
    @Test
    public void testSetData_setWithProtectedData() throws Exception {
        byte[] certData = CertificateRepositoryTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        byte[] protectedCertData = CertUtils.changePkcs12Protection((byte[])certData, (char[])"".toCharArray(), (char[])"".toCharArray(), (char[])"12345".toCharArray(), (char[])"67890".toCharArray());
        Certificate cert = new Certificate();
        cert.setData(protectedCertData);
    }

    @Test
    public void testSetData_setCertAndKeyData() throws Exception {
        byte[] certData = FileUtils.readFileToByteArray((File)new File("./src/test/resources/certs/gm2552.der"));
        byte[] keyData = FileUtils.readFileToByteArray((File)new File("./src/test/resources/certs/gm2552Key.der"));
        byte[] rawCertData = CertUtils.certAndWrappedKeyToRawByteFormat((byte[])keyData, (X509Certificate)CertUtils.toX509Certificate((byte[])certData));
        Certificate cert = new Certificate();
        cert.setData(rawCertData);
    }
}

