/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.nhindirect.common.cert.Thumbprint;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.CertificateException;
import org.nhindirect.config.store.EntityStatus;

@Entity
@Table(name="anchor")
public class Anchor {
    private String owner;
    private String thumbprint;
    private long certificateId;
    private byte[] certificateData;
    private long id;
    private Calendar createTime;
    private Calendar validStartDate;
    private Calendar validEndDate;
    private EntityStatus status;
    private boolean incoming;
    private boolean outgoing;

    @Column(name="owner")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Column(name="thumbprint")
    public String getThumbprint() {
        return this.thumbprint;
    }

    public void setThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
    }

    @Column(name="certificateData", length=4096)
    @Lob
    public byte[] getData() {
        return this.certificateData;
    }

    public void setData(byte[] data) throws CertificateException {
        this.certificateData = data;
        if (data == Certificate.NULL_CERT) {
            this.setThumbprint("");
        } else {
            this.loadCertFromData();
        }
    }

    @Id
    @Column(name="id", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Calendar timestamp) {
        this.createTime = timestamp;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getValidStartDate() {
        return this.validStartDate;
    }

    public void setValidStartDate(Calendar validStartDate) {
        this.validStartDate = validStartDate;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getValidEndDate() {
        return this.validEndDate;
    }

    public void setValidEndDate(Calendar validEndDate) {
        this.validEndDate = validEndDate;
    }

    @Enumerated
    public EntityStatus getStatus() {
        return this.status;
    }

    public void setStatus(EntityStatus status) {
        this.status = status;
    }

    @Column(name="forIncoming")
    public boolean isIncoming() {
        return this.incoming;
    }

    public void setIncoming(boolean incoming) {
        this.incoming = incoming;
    }

    @Column(name="forOutgoing")
    public boolean isOutgoing() {
        return this.outgoing;
    }

    public void setOutgoing(boolean outgoing) {
        this.outgoing = outgoing;
    }

    public long getCertificateId() {
        return this.certificateId;
    }

    public void setCertificateId(long certificateId) {
        this.certificateId = certificateId;
    }

    private X509Certificate loadCertFromData() throws CertificateException {
        X509Certificate cert = null;
        try {
            this.validate();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.certificateData);
            cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            this.setThumbprint(Thumbprint.toThumbprint((X509Certificate)cert).toString());
            bais.close();
        }
        catch (Exception e) {
            this.setData(Certificate.NULL_CERT);
            throw new CertificateException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return cert;
    }

    public X509Certificate toCertificate() throws CertificateException {
        X509Certificate cert = null;
        try {
            this.validate();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.certificateData);
            cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            bais.close();
        }
        catch (Exception e) {
            throw new CertificateException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return cert;
    }

    private boolean hasData() {
        return this.certificateData != null && !this.certificateData.equals(Certificate.NULL_CERT);
    }

    public void validate() throws CertificateException {
        if (!this.hasData()) {
            throw new CertificateException("Invalid Certificate: no certificate data exists");
        }
    }
}

