/* 
 Copyright (c) 2010, Direct Project
 All rights reserved.

 Authors:
    Greg Meyer     gm2552@cerner.com
  
Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
Neither the name of The Direct Project (directproject.org) nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
*/

package org.nhindirect.config.store;

import java.time.LocalDateTime;

import org.springframework.data.annotation.Id;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.Table;

/**
 * The JPA settings class.  This tables holds various configuration settings such as how the configuration service should behave or settings
 * for a gateway.  This structure is made up of simple name value pairs. 
 */
@Table
public class Setting 
{
    private String name;
    private String value;
    
    @Id
    private Long id;
    
    @Column("createTime")
    private LocalDateTime createTime;
    
    @Column("updateTime")
    private LocalDateTime updateTime;
    
    private int status = EntityStatus.NEW.ordinal();
    
    /**
     * Get the name of the setting.
     * 
     * @return the name of the setting.
     */
    public String getName() {
        return name;
    }

    /**
     * Set the name of the setting.
     * 
     * @param name
     *            The name of setting.
     */
    public void setName(String name) {
        this.name = name;
    }    
    
    /**
     * Get the value of the setting.
     * 
     * @return the value of the setting.
     */
    public String getValue() {
        return value;
    }

    /**
     * Set the name of the setting.
     * 
     * @param name
     *            The value of setting.
     */
    public void setValue(String value) {
        this.value = value;
    }      
    
    /**
     * Get the value of id.
     * 
     * @return the value of id.
     */
    public Long getId() {
        return id;
    }

    /**
     * Set the value of id.
     * 
     * @param id
     *            The value of id.
     */
    public void setId(Long id) {
        this.id = id;
    }
    
    /**
     * Get the value of status.
     * 
     * @return the value of status.
     */
    public int getStatus() {
        return status;
    }

    /**
     * Set the value of status.
     * 
     * @param status
     *            The value of status.
     */
    public void setStatus(int status) {
        this.status = status;
    }
    
    /**
     * Get the value of createTime.
     * 
     * @return the value of createTime.
     */
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    /**
     * Set the value of createTime.
     * 
     * @param timestamp
     *            The value of createTime.
     */
    public void setCreateTime(LocalDateTime timestamp) {
        createTime = timestamp;
    }   
    
    /**
     * Get the value of updateTime.
     * 
     * @return the value of updateTime.
     */
    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    /**
     * Set the value of updateTime.
     * 
     * @param timestamp
     *            The value of updateTime.
     */
    public void setUpdateTime(LocalDateTime timestamp) {
        updateTime = timestamp;
    }     
}
