/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nhindirect.config.SpringBaseTest;
import org.nhindirect.config.repository.AnchorRepository;
import org.nhindirect.config.store.Anchor;
import org.nhindirect.config.store.EntityStatus;
import org.springframework.beans.factory.annotation.Autowired;
import reactor.test.StepVerifier;

public class AnchorRepositoryTest
extends SpringBaseTest {
    private static final String certBasePath = "src/test/resources/certs/";
    private static final String TEST_DOMAIN = "TestDomain1";
    @Autowired
    private AnchorRepository repo;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.repo.deleteAll().block();
    }

    private void addTestAnchors() throws Exception {
        Anchor anchor = new Anchor();
        anchor.setData(AnchorRepositoryTest.loadCertificateData("secureHealthEmailCACert.der"));
        anchor.setOwner(TEST_DOMAIN);
        anchor.setOutgoing(true);
        anchor.setIncoming(true);
        ((StepVerifier.FirstStep)this.repo.save((Object)anchor).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        anchor = new Anchor();
        anchor.setData(AnchorRepositoryTest.loadCertificateData("cacert.der"));
        anchor.setOwner(TEST_DOMAIN);
        anchor.setOutgoing(true);
        anchor.setIncoming(true);
        ((StepVerifier.FirstStep)this.repo.save((Object)anchor).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
    }

    private static byte[] loadCertificateData(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        return FileUtils.readFileToByteArray((File)fl);
    }

    @Test
    public void testCleanDatabase() throws Exception {
        ((StepVerifier.FirstStep)this.repo.findAll().as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testDeleteByIds() throws Exception {
        this.addTestAnchors();
        List anchors = (List)this.repo.findAll().collectList().block();
        Assert.assertNotNull((Object)anchors);
        Assert.assertTrue((anchors.size() > 0 ? 1 : 0) != 0);
        for (Anchor anchorToDel : anchors) {
            ((StepVerifier.FirstStep)this.repo.deleteById((Object)anchorToDel.getId()).as(StepVerifier::create)).verifyComplete();
        }
        ((StepVerifier.FirstStep)this.repo.findAll().as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testAddAnchor() throws Exception {
        this.addTestAnchors();
        List anchors = (List)this.repo.findAll().collectList().block();
        Assert.assertNotNull((Object)anchors);
        Assert.assertEquals((long)2L, (long)anchors.size());
        Anchor retAnchor = (Anchor)anchors.get(0);
        Assert.assertEquals((Object)retAnchor.getOwner(), (Object)TEST_DOMAIN);
    }

    @Test
    public void testGetByOwner() throws Exception {
        this.testCleanDatabase();
        this.addTestAnchors();
        List anchors = (List)this.repo.findByOwnerIgnoreCase(TEST_DOMAIN).collectList().block();
        Assert.assertNotNull((Object)anchors);
        Assert.assertEquals((long)2L, (long)anchors.size());
        for (Anchor retAnchor : anchors) {
            Assert.assertEquals((Object)retAnchor.getOwner(), (Object)TEST_DOMAIN);
        }
    }

    @Test
    public void testUpdateByIds() throws Exception {
        this.addTestAnchors();
        List anchors = (List)this.repo.findAll().collectList().block();
        Assert.assertEquals((long)2L, (long)anchors.size());
        for (Anchor anchor : anchors) {
            anchor.setStatus(EntityStatus.ENABLED.ordinal());
        }
        ((StepVerifier.FirstStep)this.repo.saveAll((Iterable)anchors).as(StepVerifier::create)).expectNextCount(2L).verifyComplete();
        anchors = (List)this.repo.findAll().collectList().block();
        Assert.assertEquals((long)2L, (long)anchors.size());
        for (Anchor anchor : anchors) {
            Assert.assertEquals((long)EntityStatus.ENABLED.ordinal(), (long)anchor.getStatus());
            Assert.assertEquals((Object)TEST_DOMAIN, (Object)anchor.getOwner());
        }
    }

    @Test
    public void testUpdateByOwner() throws Exception {
        this.addTestAnchors();
        List anchors = (List)this.repo.findByOwnerIgnoreCase(TEST_DOMAIN.toUpperCase()).collectList().block();
        Assert.assertEquals((long)2L, (long)anchors.size());
        for (Anchor anchor : anchors) {
            anchor.setStatus(EntityStatus.ENABLED.ordinal());
        }
        ((StepVerifier.FirstStep)this.repo.saveAll((Iterable)anchors).as(StepVerifier::create)).expectNextCount(2L).verifyComplete();
        anchors = (List)this.repo.findByOwnerIgnoreCase(TEST_DOMAIN.toUpperCase()).collectList().block();
        Assert.assertEquals((long)2L, (long)anchors.size());
        for (Anchor anchor : anchors) {
            Assert.assertEquals((long)EntityStatus.ENABLED.ordinal(), (long)anchor.getStatus());
            Assert.assertEquals((Object)TEST_DOMAIN, (Object)anchor.getOwner());
        }
    }
}

