/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.CertPolicyGroupDomainReltn;
import org.nhindirect.config.store.Domain;
import org.springframework.transaction.annotation.Transactional;
import reactor.test.StepVerifier;

@Transactional
public class CertPolicyGroupDomainReltnRepository_disassociatePolicyGroupFromDomainsTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testDisassociatePolicyGroupFromDomains_associateDomainAndPolicy_assertAssociationRemoved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroupDomainReltn addreltn = new CertPolicyGroupDomainReltn();
        addreltn.setCertPolicyGroupId(group.getId());
        addreltn.setDomainId(domain.getId());
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)addreltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection reltn = (Collection)this.reltnRepo.findByDomainId(domain.getId()).collectList().block();
        Assert.assertEquals((long)1L, (long)reltn.size());
        this.reltnRepo.deleteByCertPolicyGroupId(group.getId()).block();
        reltn = (Collection)this.reltnRepo.findByDomainId(domain.getId()).collectList().block();
        Assert.assertEquals((long)0L, (long)reltn.size());
    }
}

