/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.CertPolicyGroupDomainReltn;
import org.nhindirect.config.store.Domain;
import org.springframework.transaction.annotation.Transactional;
import reactor.test.StepVerifier;

@Transactional
public class CertPolicyGroupDomainReltnRepository_disassociatePolicyGroupsFromDomainTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testDisassociatePolicyGroupsFromDomain_associateDomainAndPolicy_assertAssociationRemoved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroupDomainReltn addReltn = new CertPolicyGroupDomainReltn();
        addReltn.setCertPolicyGroupId(group.getId());
        addReltn.setDomainId(domain.getId());
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)addReltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection reltn = (Collection)this.reltnRepo.findByDomainId(domain.getId()).collectList().block();
        Assert.assertEquals((long)1L, (long)reltn.size());
        this.reltnRepo.deleteByDomainId(domain.getId()).block();
        reltn = (Collection)this.reltnRepo.findByDomainId(domain.getId()).collectList().block();
        Assert.assertEquals((long)0L, (long)reltn.size());
    }
}

