/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.CertPolicyGroupReltn;
import org.nhindirect.config.store.CertPolicyUse;
import org.nhindirect.policy.PolicyLexicon;
import reactor.test.StepVerifier;

public class CertPolicyGroupRepository_addPolicyUseToGroupTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testAddPolicyToGroup_associatePolicyAndGroup_assertAssociationAdded() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML.ordinal());
        policy.setPolicyData(new byte[]{1, 2, 3});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroupReltn reltn = new CertPolicyGroupReltn();
        reltn.setCertPolicyId(policy.getId());
        reltn.setCertPolicyGroupId(group.getId());
        reltn.setPolicyUse(CertPolicyUse.PUBLIC_RESOLVER.ordinal());
        reltn.setIncoming(true);
        reltn.setOutgoing(false);
        ((StepVerifier.FirstStep)this.groupReltRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        List assocGroups = (List)this.groupReltRepo.findByGroupId(group.getId()).collectList().block();
        Assert.assertEquals((long)1L, (long)assocGroups.size());
        reltn = (CertPolicyGroupReltn)assocGroups.get(0);
        Assert.assertEquals((Object)policy.getId(), (Object)reltn.getCertPolicyId());
        Assert.assertEquals((Object)group.getId(), (Object)reltn.getCertPolicyGroupId());
        Assert.assertEquals((long)CertPolicyUse.PUBLIC_RESOLVER.ordinal(), (long)reltn.getPolicyUse());
        Assert.assertTrue((boolean)reltn.isIncoming());
        Assert.assertFalse((boolean)reltn.isOutgoing());
    }
}

