/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.springframework.transaction.annotation.Transactional;
import reactor.test.StepVerifier;

@Transactional
public class CertPolicyGroupRepository_deletePolicyGroupsTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testDeletePolicyGroups_singlePolicyGroup_assertPolicyGroupDeleted() {
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection groups = (Collection)this.groupRepo.findAll().collectList().block();
        Assert.assertEquals((long)1L, (long)groups.size());
        this.groupRepo.deleteById((Object)((CertPolicyGroup)groups.iterator().next()).getId()).block();
        groups = (Collection)this.groupRepo.findAll().collectList().block();
        Assert.assertEquals((long)0L, (long)groups.size());
    }

    @Test
    public void testDeletePolicyGroups_multiplePolicyGroups_assertSinglePolicyGroupDeleted() {
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group1");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup group2 = new CertPolicyGroup();
        group2.setPolicyGroupName("Test Group2");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group2).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection groups = (Collection)this.groupRepo.findAll().collectList().block();
        Assert.assertEquals((long)2L, (long)groups.size());
        this.groupRepo.deleteById((Object)((CertPolicyGroup)groups.iterator().next()).getId()).block();
        groups = (Collection)this.groupRepo.findAll().collectList().block();
        Assert.assertEquals((long)1L, (long)groups.size());
    }

    @Test
    public void testDeletePolicyGroups_multiplePolicyGroups_assertAllPolicyGroupsDeleted() {
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group1");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup group2 = new CertPolicyGroup();
        group2.setPolicyGroupName("Test Group2");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group2).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection groups = (Collection)this.groupRepo.findAll().collectList().block();
        Assert.assertEquals((long)2L, (long)groups.size());
        Iterator iter = groups.iterator();
        this.groupRepo.deleteByIdIn(Arrays.asList(((CertPolicyGroup)iter.next()).getId(), ((CertPolicyGroup)iter.next()).getId())).block();
        groups = (Collection)this.groupRepo.findAll().collectList().block();
        Assert.assertEquals((long)0L, (long)groups.size());
    }
}

