/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import reactor.test.StepVerifier;

public class CertPolicyGroupRepository_getPolicyGroupsTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicies_emptyPolicyGroupStore_assertNoPolicGroupsRetrieved() {
        ((StepVerifier.FirstStep)this.groupRepo.findAll().as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testGetPolicies_singleEntryInPolicyGroupStore_assertPolicyGroupRetrieved() {
        LocalDateTime now = LocalDateTime.now();
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection groups = (Collection)this.groupRepo.findAll().collectList().block();
        Assert.assertEquals((long)1L, (long)groups.size());
        CertPolicyGroup addedGroup = (CertPolicyGroup)groups.iterator().next();
        Assert.assertEquals((Object)group.getPolicyGroupName(), (Object)addedGroup.getPolicyGroupName());
        Assert.assertTrue((now.compareTo(addedGroup.getCreateTime()) <= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetPolicies_multipeEntriesInPolicyGroupStore_assertPolicyGroupsRetrieved() {
        LocalDateTime now = LocalDateTime.now();
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group1");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup group2 = new CertPolicyGroup();
        group2.setPolicyGroupName("Test Group2");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group2).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection groups = (Collection)this.groupRepo.findAll().collectList().block();
        Assert.assertEquals((long)2L, (long)groups.size());
        Iterator iter = groups.iterator();
        CertPolicyGroup addedGroup = (CertPolicyGroup)iter.next();
        Assert.assertEquals((Object)group1.getPolicyGroupName(), (Object)addedGroup.getPolicyGroupName());
        Assert.assertTrue((now.compareTo(addedGroup.getCreateTime()) <= 0 ? 1 : 0) != 0);
        addedGroup = (CertPolicyGroup)iter.next();
        Assert.assertEquals((Object)group2.getPolicyGroupName(), (Object)addedGroup.getPolicyGroupName());
        Assert.assertTrue((now.compareTo(addedGroup.getCreateTime()) <= 0 ? 1 : 0) != 0);
    }
}

