/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.policy.PolicyLexicon;
import reactor.test.StepVerifier;

public class CertPolicyRepository_getPoliciesTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicies_emptyPolicyStore_assertNoPoliciesRetrieved() {
        ((StepVerifier.FirstStep)this.polRepo.findAll().as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testGetPolicies_singleEntryInPolicyStore_assertPoliciesRetrieved() {
        LocalDateTime now = LocalDateTime.now();
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test Policy");
        policy.setLexicon(PolicyLexicon.XML.ordinal());
        policy.setPolicyData(new byte[]{1, 2, 3});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection policies = (Collection)this.polRepo.findAll().collectList().block();
        Assert.assertEquals((long)1L, (long)policies.size());
        CertPolicy addedPolicy = (CertPolicy)policies.iterator().next();
        Assert.assertEquals((Object)"Test Policy", (Object)addedPolicy.getPolicyName());
        Assert.assertEquals((long)PolicyLexicon.XML.ordinal(), (long)addedPolicy.getLexicon());
        Assert.assertTrue((now.compareTo(addedPolicy.getCreateTime()) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, addedPolicy.getPolicyData()));
    }

    @Test
    public void testGetPolicies_multipeEntriesInPolicyStore_assertPoliciesRetrieved() {
        LocalDateTime now = LocalDateTime.now();
        CertPolicy policy1 = new CertPolicy();
        policy1.setPolicyName("Test Policy1");
        policy1.setLexicon(PolicyLexicon.XML.ordinal());
        policy1.setPolicyData(new byte[]{1, 2, 3});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicy policy2 = new CertPolicy();
        policy2.setPolicyName("Test Policy2");
        policy2.setLexicon(PolicyLexicon.JAVA_SER.ordinal());
        policy2.setPolicyData(new byte[]{4, 5, 6});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy2).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection policies = (Collection)this.polRepo.findAll().collectList().block();
        Assert.assertEquals((long)2L, (long)policies.size());
        Iterator iter = policies.iterator();
        CertPolicy addedPolicy = (CertPolicy)iter.next();
        Assert.assertEquals((Object)policy1.getPolicyName(), (Object)addedPolicy.getPolicyName());
        Assert.assertEquals((long)policy1.getLexicon(), (long)addedPolicy.getLexicon());
        Assert.assertTrue((now.compareTo(addedPolicy.getCreateTime()) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(policy1.getPolicyData(), addedPolicy.getPolicyData()));
        addedPolicy = (CertPolicy)iter.next();
        Assert.assertEquals((Object)policy2.getPolicyName(), (Object)addedPolicy.getPolicyName());
        Assert.assertEquals((long)policy2.getLexicon(), (long)addedPolicy.getLexicon());
        Assert.assertTrue((now.compareTo(addedPolicy.getCreateTime()) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(policy2.getPolicyData(), addedPolicy.getPolicyData()));
    }
}

