/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.time.LocalDateTime;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.policy.PolicyLexicon;
import reactor.test.StepVerifier;

public class CertPolicyRepository_getPolicyByNameTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicyByName_emptyStore_assertNoPolicyReturned() {
        ((StepVerifier.FirstStep)this.polRepo.findByPolicyNameIgnoreCase("Test Policy").as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testGetPolicyByName_singlePolicyInStore_nameNotInStore_assertNoPolicyReturned() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test Policy");
        policy.setLexicon(PolicyLexicon.XML.ordinal());
        policy.setPolicyData(new byte[]{1, 2, 3});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        ((StepVerifier.FirstStep)this.polRepo.findByPolicyNameIgnoreCase("Test Policy X").as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testGetPolicyByName_singlePolicyInStore_assertPolicyReturned() {
        LocalDateTime now = LocalDateTime.now();
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML.ordinal());
        policy.setPolicyData(new byte[]{1, 2, 3});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicy addedPolicy = (CertPolicy)this.polRepo.findByPolicyNameIgnoreCase("Test POLicY").block();
        Assert.assertEquals((Object)policy.getPolicyName(), (Object)addedPolicy.getPolicyName());
        Assert.assertEquals((long)policy.getLexicon(), (long)addedPolicy.getLexicon());
        Assert.assertTrue((now.compareTo(addedPolicy.getCreateTime()) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(policy.getPolicyData(), addedPolicy.getPolicyData()));
    }
}

