/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.io.File;
import java.security.cert.X509Certificate;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.config.SpringBaseTest;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.repository.CertificateRepository;
import org.nhindirect.config.store.Certificate;
import org.springframework.beans.factory.annotation.Autowired;
import reactor.test.StepVerifier;

public class CertificateRepository_saveTest
extends SpringBaseTest {
    @Autowired
    private CertificateRepository repo;

    @Before
    public void cleanDataBase() {
        this.repo.deleteAll();
    }

    @Test
    public void saveWithCertAndPrivKeyData() throws Exception {
        byte[] certData = FileUtils.readFileToByteArray((File)new File("./src/test/resources/certs/gm2552.der"));
        byte[] keyData = FileUtils.readFileToByteArray((File)new File("./src/test/resources/certs/gm2552Key.der"));
        Certificate addCert = new Certificate();
        addCert.setData(CertUtils.certAndWrappedKeyToRawByteFormat((byte[])keyData, (X509Certificate)CertUtils.toX509Certificate((byte[])certData)));
        addCert.setOwner("gm2552@cerner.com");
        ((StepVerifier.FirstStep)this.repo.save((Object)addCert).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Certificate cert = (Certificate)this.repo.findAll().blockFirst();
        Assert.assertTrue((boolean)cert.isPrivateKey());
        CertUtils.CertContainer container = CertUtils.toCertContainer((byte[])certData);
        Assert.assertEquals((Object)container.getCert(), (Object)CertUtils.toCertContainer((byte[])cert.getData()).getCert());
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

