/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.config.SpringBaseTest;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.repository.CertificateRepository;
import org.nhindirect.config.repository.CertificateRepositoryTest;
import org.nhindirect.config.store.Certificate;
import org.springframework.beans.factory.annotation.Autowired;
import reactor.test.StepVerifier;

public class CertificateRepository_stripP12ProtectionWithManagerTest
extends SpringBaseTest {
    private static final String certBasePath = "src/test/resources/certs/";
    @Autowired
    private CertificateRepository repo;

    @Before
    public void cleanDataBase() {
        this.repo.deleteAll().block();
    }

    private static byte[] loadCertificateData(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        return FileUtils.readFileToByteArray((File)fl);
    }

    protected Certificate populateCert(String certFile, String keyFile) throws Exception {
        byte[] certData = keyFile != null && !keyFile.isEmpty() ? CertificateRepositoryTest.loadPkcs12FromCertAndKey(certFile, keyFile) : CertificateRepository_stripP12ProtectionWithManagerTest.loadCertificateData(certFile);
        Certificate cert = new Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        ((StepVerifier.FirstStep)this.repo.save((Object)cert).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        return cert;
    }

    @Test
    public void testStripP12ProtectionTest_p12ProtectionWithManager_assertP12Returned() throws Exception {
        this.populateCert("gm2552.der", "gm2552Key.der");
        Certificate cert = (Certificate)this.repo.findAll().blockFirst();
        Assert.assertTrue((boolean)cert.isPrivateKey());
        byte[] certData = CertificateRepositoryTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        CertUtils.CertContainer container = CertUtils.toCertContainer((byte[])certData);
        Assert.assertEquals((Object)container.getCert(), (Object)CertUtils.toCertContainer((byte[])cert.getData()).getCert());
    }

    @Test
    public void testStripP12ProtectionTest_X509CertAndManager_assertX509Returned() throws Exception {
        this.populateCert("gm2552.der", null);
        Certificate cert = (Certificate)this.repo.findAll().blockFirst();
        Assert.assertFalse((boolean)cert.isPrivateKey());
        byte[] certData = CertificateRepository_stripP12ProtectionWithManagerTest.loadCertificateData("gm2552.der");
        CertUtils.CertContainer container = CertUtils.toCertContainer((byte[])certData);
        Assert.assertEquals((Object)container.getCert(), (Object)CertUtils.toCertContainer((byte[])cert.getData()).getCert());
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

