/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.time.LocalDateTime;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nhindirect.config.SpringBaseTest;
import org.nhindirect.config.repository.SettingRepository;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.Setting;
import org.springframework.beans.factory.annotation.Autowired;
import reactor.test.StepVerifier;

public class SettingRepositoryTest
extends SpringBaseTest {
    @Autowired
    private SettingRepository repo;

    protected Setting newSetting(String name, String value) {
        Setting retVal = new Setting();
        retVal.setName(name);
        retVal.setValue(value);
        retVal.setStatus(EntityStatus.ENABLED.ordinal());
        retVal.setUpdateTime(LocalDateTime.now());
        retVal.setUpdateTime(LocalDateTime.now());
        return retVal;
    }

    private void addSetting(String name, String value) throws Exception {
        this.repo.save((Object)this.newSetting(name, value)).block();
    }

    @Before
    public void cleanDataBase() {
        ((StepVerifier.FirstStep)this.repo.deleteAll().as(StepVerifier::create)).verifyComplete();
    }

    @Test
    public void testCleanDatabase() throws Exception {
        ((StepVerifier.FirstStep)this.repo.findAll().as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void addSettings() throws Exception {
        this.addSetting("TestName1", "TestValue1");
        this.addSetting("TestName2", "TestValue2");
        Collection settings = (Collection)this.repo.findAll().collectList().block();
        Assert.assertEquals((long)2L, (long)settings.size());
    }

    @Test
    public void testAddDuplicateSettings_AssertException() throws Exception {
        this.addSetting("TestName1", "TestValue1");
        boolean exceptionOccured = false;
        try {
            this.addSetting("TestName1", "TestValue2");
        }
        catch (Exception e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testGetAllSettings() throws Exception {
        this.addSetting("TestName1", "TestValue1");
        this.addSetting("TestName2", "TestValue2");
        Collection settings = (Collection)this.repo.findAll().collectList().block();
        Assert.assertEquals((long)2L, (long)settings.size());
        this.addSetting("TestName3", "TestValue3");
        this.addSetting("TestName4", "TestValue4");
        this.addSetting("TestName5", "TestValue5");
        settings = (Collection)this.repo.findAll().collectList().block();
        Assert.assertEquals((long)5L, (long)settings.size());
    }

    @Test
    public void testGetSettingsByName() throws Exception {
        this.addSetting("TestName1", "TestValue1");
        this.addSetting("TestName2", "TestValue2");
        Setting setting = (Setting)this.repo.findByNameIgnoreCase("TestName1".toUpperCase()).block();
        Assert.assertEquals((Object)"TestValue1", (Object)setting.getValue());
        setting = (Setting)this.repo.findByNameIgnoreCase("TestNAme2".toUpperCase()).block();
        Assert.assertEquals((Object)"TestName2", (Object)setting.getName());
        Assert.assertEquals((Object)"TestValue2", (Object)setting.getValue());
    }

    @Test
    public void testUpdateSetting() throws Exception {
    }
}

