/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.common.cert.Thumbprint;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;
import org.springframework.dao.DataIntegrityViolationException;
import reactor.test.StepVerifier;

public class TrustBundleRepository_addTrustBundleTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testAddTrustBundle_addBundle_noAnchors_assertAdded() {
        LocalDateTime now = LocalDateTime.now();
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection bundles = (Collection)this.tbRepo.findAll().collectList().block();
        Assert.assertEquals((long)1L, (long)bundles.size());
        TrustBundle addedBundle = (TrustBundle)bundles.iterator().next();
        Assert.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.compareTo(addedBundle.getCreateTime()) <= 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertEquals((long)0L, (long)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
    }

    @Test
    public void testAddTrustBundle_addBundle_withAnchors_assertAdded() throws Exception {
        LocalDateTime now = LocalDateTime.now();
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection bundles = (Collection)this.tbRepo.findAll().collectList().block();
        Assert.assertEquals((long)1L, (long)bundles.size());
        TrustBundle addedBundle = (TrustBundle)bundles.iterator().next();
        TrustBundleAnchor anchor = new TrustBundleAnchor();
        anchor.setData(TrustBundleRepository_addTrustBundleTest.loadCertificateData("secureHealthEmailCACert.der"));
        anchor.setTrustBundleId(addedBundle.getId());
        ((StepVerifier.FirstStep)this.tbAncRepo.save((Object)anchor).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Assert.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.compareTo(addedBundle.getCreateTime()) <= 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertEquals((long)0L, (long)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
        List addedAnchors = (List)this.tbAncRepo.findByTrustBundleId(addedBundle.getId()).collectList().block();
        Assert.assertEquals((long)1L, (long)addedAnchors.size());
        TrustBundleAnchor addedAnchor = (TrustBundleAnchor)addedAnchors.get(0);
        Assert.assertNotNull((Object)addedAnchor.toCertificate());
        Assert.assertEquals((Object)anchor.toCertificate(), (Object)addedAnchor.toCertificate());
        Assert.assertEquals((Object)Thumbprint.toThumbprint((X509Certificate)anchor.toCertificate()).toString(), (Object)addedAnchor.getThumbprint());
        Assert.assertEquals((long)anchor.toCertificate().getNotAfter().getTime(), (long)Timestamp.valueOf(addedAnchor.getValidEndDate()).getTime());
        Assert.assertEquals((long)anchor.toCertificate().getNotBefore().getTime(), (long)Timestamp.valueOf(addedAnchor.getValidStartDate()).getTime());
        Assert.assertEquals((Object)anchor.getTrustBundleId(), (Object)addedBundle.getId());
    }

    @Test
    public void testAddTrustBundle_addExistingBundle_assertException() {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        List bundles = (List)this.tbRepo.findAll().collectList().block();
        Assert.assertEquals((long)1L, (long)bundles.size());
        boolean exceptionOccured = false;
        try {
            bundle = new TrustBundle();
            bundle.setBundleName("Test Bundle");
            bundle.setBundleURL("http://testBundle/bundle.p7b");
            bundle.setRefreshInterval(5);
            bundle.setCheckSum("12345");
            bundle.setCreateTime(LocalDateTime.now());
            this.tbRepo.save((Object)bundle).block();
        }
        catch (DataIntegrityViolationException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        bundles = (List)this.tbRepo.findAll().collectList().block();
        Assert.assertEquals((long)1L, (long)bundles.size());
    }
}

