/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.TrustBundle;
import reactor.test.StepVerifier;

public class TrustBundleRepository_deleteTrustBundlesTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testDeleteTrustBundlesTest_singleBundle_assertBundleDeleted() {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        List bundles = (List)this.tbRepo.findAll().collectList().block();
        Assert.assertEquals((long)1L, (long)bundles.size());
        ((StepVerifier.FirstStep)this.tbRepo.deleteAll((Iterable)bundles).as(StepVerifier::create)).verifyComplete();
        bundles = (List)this.tbRepo.findAll().collectList().block();
        Assert.assertEquals((long)0L, (long)bundles.size());
    }

    @Test
    public void testDeleteTrustBundlesTest_multipleBundles_assertSingleBundleDeleted() {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle2");
        bundle.setBundleURL("http://testBundle/bundle2.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("67890");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection bundles = (Collection)this.tbRepo.findAll().collectList().block();
        Assert.assertEquals((long)2L, (long)bundles.size());
        ((StepVerifier.FirstStep)this.tbRepo.deleteById((Object)((TrustBundle)bundles.iterator().next()).getId()).as(StepVerifier::create)).verifyComplete();
        bundles = (Collection)this.tbRepo.findAll().collectList().block();
        Assert.assertEquals((long)1L, (long)bundles.size());
    }

    @Test
    public void testDeleteTrustBundlesTest_multipleBundles_assertAllBundlesDeleted() {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle2");
        bundle.setBundleURL("http://testBundle/bundle2.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("67890");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        List bundles = (List)this.tbRepo.findAll().collectList().block();
        Assert.assertEquals((long)2L, (long)bundles.size());
        ((StepVerifier.FirstStep)this.tbRepo.deleteAll().as(StepVerifier::create)).verifyComplete();
        bundles = (List)this.tbRepo.findAll().collectList().block();
        Assert.assertEquals((long)0L, (long)bundles.size());
    }
}

