/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleDomainReltn;
import org.springframework.transaction.annotation.Transactional;
import reactor.test.StepVerifier;

@Transactional
public class TrustBundleRepository_disassociateTrustBundleFromDomainTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testDisassociateTrustBundleFromDomain_associateDomainAndBundle_assertAssociationRemoved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://test/url/bundle");
        bundle.setCheckSum("1234");
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
        reltn.setDomainId(domain.getId());
        reltn.setTrustBundleId(bundle.getId());
        reltn.setIncoming(true);
        reltn.setOutgoing(true);
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        List bundles = (List)this.reltnRepo.findByDomainId(domain.getId()).collectList().block();
        Assert.assertEquals((long)1L, (long)bundles.size());
        TrustBundleDomainReltn foudnReltn = (TrustBundleDomainReltn)bundles.get(0);
        Assert.assertEquals((Object)foudnReltn.getDomainId(), (Object)domain.getId());
        Assert.assertEquals((Object)foudnReltn.getTrustBundleId(), (Object)bundle.getId());
        this.reltnRepo.deleteByDomainId(domain.getId()).block();
        bundles = (List)this.reltnRepo.findByDomainId(domain.getId()).collectList().block();
        Assert.assertEquals((long)0L, (long)bundles.size());
    }

    @Test
    public void testDisassociateTrustBundleFromDomainByBothIds_associateDomainAndBundle_assertAssociationRemoved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://test/url/bundle");
        bundle.setCheckSum("1234");
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
        reltn.setDomainId(domain.getId());
        reltn.setTrustBundleId(bundle.getId());
        reltn.setIncoming(true);
        reltn.setOutgoing(true);
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        List bundles = (List)this.reltnRepo.findByDomainId(domain.getId()).collectList().block();
        Assert.assertEquals((long)1L, (long)bundles.size());
        TrustBundleDomainReltn foudnReltn = (TrustBundleDomainReltn)bundles.get(0);
        Assert.assertEquals((Object)foudnReltn.getDomainId(), (Object)domain.getId());
        Assert.assertEquals((Object)foudnReltn.getTrustBundleId(), (Object)bundle.getId());
        this.reltnRepo.deleteByDomainIdAndTrustBundleId(domain.getId(), bundle.getId()).block();
        bundles = (List)this.reltnRepo.findByDomainId(domain.getId()).collectList().block();
        Assert.assertEquals((long)0L, (long)bundles.size());
    }
}

