/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.time.LocalDateTime;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.TrustBundle;
import reactor.test.StepVerifier;

public class TrustBundleRepository_getTrustBundleByIdTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testTetTrustBundleById_emptyStore_assertNoBundleReturned() {
        Assert.assertEquals(null, (Object)this.tbRepo.findById((Object)1234L).block());
    }

    @Test
    public void testTetTrustBundleById_singleBundleInStore_idNotInStore_assertNoBundleReturned() {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Assert.assertEquals(null, (Object)this.tbRepo.findById((Object)1234L).block());
    }

    @Test
    public void testTetTrustBundleById_singleBundleInStore_assertBundleReturned() {
        LocalDateTime now = LocalDateTime.now();
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setCheckSum("12345");
        bundle.setRefreshInterval(5);
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle addedBundle = (TrustBundle)this.tbRepo.findById((Object)bundle.getId()).block();
        Assert.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.compareTo(addedBundle.getCreateTime()) <= 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertEquals((long)0L, (long)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
    }
}

