/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.time.LocalDateTime;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.TrustBundle;
import reactor.test.StepVerifier;

public class TrustBundleRepository_getTrustBundleByNameTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testTetTrustBundleByName_emptyStore_assertNoBundleReturned() {
        Assert.assertNull((Object)this.tbRepo.findByBundleNameIgnoreCase("Test Bundle").block());
    }

    @Test
    public void testTetTrustBundleByName_singleBundleInStore_nameNotInStore_assertNoBundleReturned() {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Assert.assertNull((Object)this.tbRepo.findByBundleNameIgnoreCase("Test Bundle X").block());
    }

    @Test
    public void testTetTrustBundleByName_singleBundleInStore_assertBundleReturned() {
        LocalDateTime now = LocalDateTime.now();
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle addedBundle = (TrustBundle)this.tbRepo.findByBundleNameIgnoreCase("Test BundLE").block();
        Assert.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.compareTo(addedBundle.getCreateTime()) <= 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertEquals((long)0L, (long)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
    }
}

