/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Collection;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleDomainReltn;
import reactor.test.StepVerifier;

public class TrustBundleRepository_getTrustBundlesByDomainTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testGetTrustBundlesByDomain_associationsExist_assertBundlesRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://test/url/bundle");
        bundle.setCheckSum("1234");
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
        reltn.setDomainId(domain.getId());
        reltn.setTrustBundleId(bundle.getId());
        reltn.setIncoming(true);
        reltn.setOutgoing(true);
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection bundles = (Collection)this.reltnRepo.findByDomainId(domain.getId()).collectList().block();
        Assert.assertEquals((long)1L, (long)bundles.size());
    }

    @Test
    public void testGetTrustBundlesByDomain_multipleAssociationsExist_assertBundlesRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle bundle1 = new TrustBundle();
        bundle1.setBundleName("Test Bundle");
        bundle1.setBundleURL("http://test/url/bundle");
        bundle1.setCheckSum("1234");
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle bundle2 = new TrustBundle();
        bundle2.setBundleName("Test Bundle2");
        bundle2.setBundleURL("http://test/url/bundle2");
        bundle2.setCheckSum("1234");
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle2).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
        reltn.setDomainId(domain.getId());
        reltn.setTrustBundleId(bundle1.getId());
        reltn.setIncoming(true);
        reltn.setOutgoing(true);
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        reltn = new TrustBundleDomainReltn();
        reltn.setDomainId(domain.getId());
        reltn.setTrustBundleId(bundle2.getId());
        reltn.setIncoming(true);
        reltn.setOutgoing(true);
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection bundles = (Collection)this.reltnRepo.findByDomainId(domain.getId()).collectList().block();
        Assert.assertEquals((long)2L, (long)bundles.size());
        Iterator bundleIter = bundles.iterator();
        Assert.assertEquals((Object)bundle1.getId(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundleId());
        Assert.assertEquals((Object)bundle2.getId(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundleId());
    }

    @Test
    public void testGetTrustBundlesByDomain_multipleAssociationsExist_oneToEachDomain_assertBundlesRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Domain domain2 = new Domain();
        domain2.setDomainName("Test Domain 2");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain2).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle bundle1 = new TrustBundle();
        bundle1.setBundleName("Test Bundle");
        bundle1.setBundleURL("http://test/url/bundle");
        bundle1.setCheckSum("1234");
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle bundle2 = new TrustBundle();
        bundle2.setBundleName("Test Bundle2");
        bundle2.setBundleURL("http://test/url/bundle2");
        bundle2.setCheckSum("1234");
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle2).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
        reltn.setDomainId(domain1.getId());
        reltn.setTrustBundleId(bundle1.getId());
        reltn.setIncoming(true);
        reltn.setOutgoing(true);
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        reltn = new TrustBundleDomainReltn();
        reltn.setDomainId(domain2.getId());
        reltn.setTrustBundleId(bundle2.getId());
        reltn.setIncoming(true);
        reltn.setOutgoing(true);
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection bundles = (Collection)this.reltnRepo.findByDomainId(domain1.getId()).collectList().block();
        Assert.assertEquals((long)1L, (long)bundles.size());
        Iterator bundleIter = bundles.iterator();
        Assert.assertEquals((Object)bundle1.getId(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundleId());
        bundles = (Collection)this.reltnRepo.findByDomainId(domain2.getId()).collectList().block();
        Assert.assertEquals((long)1L, (long)bundles.size());
        bundleIter = bundles.iterator();
        Assert.assertEquals((Object)bundle2.getId(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundleId());
    }

    @Test
    public void testGetTrustBundlesByDomain_multipleAssociationsExist_bundleToMultipeDomains_assertBundlesRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain 1");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Domain domain2 = new Domain();
        domain2.setDomainName("Test Domain 2");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain2).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle bundle1 = new TrustBundle();
        bundle1.setBundleName("Test Bundle1");
        bundle1.setBundleURL("http://test/url/bundle1");
        bundle1.setCheckSum("1234");
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
        reltn.setDomainId(domain1.getId());
        reltn.setTrustBundleId(bundle1.getId());
        reltn.setIncoming(true);
        reltn.setOutgoing(true);
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        reltn = new TrustBundleDomainReltn();
        reltn.setDomainId(domain2.getId());
        reltn.setTrustBundleId(bundle1.getId());
        reltn.setIncoming(true);
        reltn.setOutgoing(true);
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection bundles = (Collection)this.reltnRepo.findByDomainId(domain1.getId()).collectList().block();
        Assert.assertEquals((long)1L, (long)bundles.size());
        Iterator bundleIter = bundles.iterator();
        Assert.assertEquals((Object)bundle1.getId(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundleId());
        bundles = (Collection)this.reltnRepo.findByDomainId(domain2.getId()).collectList().block();
        Assert.assertEquals((long)1L, (long)bundles.size());
        bundleIter = bundles.iterator();
        Assert.assertEquals((Object)bundle1.getId(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundleId());
    }

    @Test
    public void testGetTrustBundlesByDomain_noBundlesInDomain_assertBundlesNotRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain 1");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection bundles = (Collection)this.reltnRepo.findByDomainId(domain1.getId()).collectList().block();
        Assert.assertEquals((long)0L, (long)bundles.size());
    }
}

