/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.time.LocalDateTime;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.BundleRefreshError;
import org.nhindirect.config.store.TrustBundle;
import reactor.test.StepVerifier;

public class TrustBundleRepository_updateLastUpdateErrorTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testUpdateLastUpdateError_updateUpdate_assertErrorUpdate() {
        LocalDateTime now = LocalDateTime.now();
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        bundle.setLastRefreshError(BundleRefreshError.SUCCESS.ordinal());
        bundle.setLastRefreshAttempt(now);
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle updatedBundle = (TrustBundle)((List)this.tbRepo.findAll().collectList().block()).get(0);
        Assert.assertEquals((long)BundleRefreshError.SUCCESS.ordinal(), (long)updatedBundle.getLastRefreshError());
        Assert.assertEquals((Object)now, (Object)updatedBundle.getLastRefreshAttempt());
        bundle.setLastRefreshError(BundleRefreshError.NOT_FOUND.ordinal());
        bundle.setLastRefreshAttempt(now);
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        updatedBundle = (TrustBundle)((List)this.tbRepo.findAll().collectList().block()).get(0);
        Assert.assertEquals((long)BundleRefreshError.NOT_FOUND.ordinal(), (long)updatedBundle.getLastRefreshError());
    }
}

