/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.time.LocalDateTime;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;
import reactor.test.StepVerifier;

public class TrustBundleRepository_updateTrustBundleAnchorsTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testUpdateTrustBundleAnchors_addNewAnchors_assertNewAnchors() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        bundle = (TrustBundle)((List)this.tbRepo.findAll().collectList().block()).get(0);
        TrustBundleAnchor anchor = new TrustBundleAnchor();
        anchor.setData(TrustBundleRepository_updateTrustBundleAnchorsTest.loadCertificateData("secureHealthEmailCACert.der"));
        anchor.setTrustBundleId(bundle.getId());
        ((StepVerifier.FirstStep)this.tbAncRepo.save((Object)anchor).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        List addedAnchors = (List)this.tbAncRepo.findByTrustBundleId(bundle.getId()).collectList().block();
        Assert.assertEquals((long)1L, (long)addedAnchors.size());
        TrustBundleAnchor addedAnchor = (TrustBundleAnchor)addedAnchors.get(0);
        Assert.assertEquals((Object)anchor.toCertificate(), (Object)addedAnchor.toCertificate());
    }
}

