/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.time.LocalDateTime;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;
import reactor.test.StepVerifier;

public class TrustBundleRepository_updateTrustBundleAttributesTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testTrustBundleAttributes_updateCert_assertCertUpdated() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundleAnchor anchor = new TrustBundleAnchor();
        anchor.setData(TrustBundleRepository_updateTrustBundleAttributesTest.loadCertificateData("secureHealthEmailCACert.der"));
        bundle.setSigningCertificateData(anchor.toCertificate().getEncoded());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle updatedBundle = (TrustBundle)this.tbRepo.findById((Object)bundle.getId()).block();
        Assert.assertEquals((Object)bundle.getBundleName(), (Object)updatedBundle.getBundleName());
        Assert.assertEquals((Object)bundle.getBundleURL(), (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)bundle.getRefreshInterval(), (long)updatedBundle.getRefreshInterval());
        Assert.assertEquals((Object)anchor.toCertificate(), (Object)updatedBundle.toSigningCertificate());
    }

    @Test
    public void testTrustBundleAttributes_updateCert_setNull_assertCertNull() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setSigningCertificateData(TrustBundleRepository_updateTrustBundleAttributesTest.loadCertificateData("secureHealthEmailCACert.der"));
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        bundle.setSigningCertificateData(null);
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle updatedBundle = (TrustBundle)this.tbRepo.findById((Object)bundle.getId()).block();
        Assert.assertEquals((Object)bundle.getBundleName(), (Object)updatedBundle.getBundleName());
        Assert.assertEquals((Object)bundle.getBundleURL(), (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)bundle.getRefreshInterval(), (long)updatedBundle.getRefreshInterval());
        Assert.assertNull((Object)updatedBundle.getSigningCertificateData());
    }

    @Test
    public void testUpdateTrustBundleSigningCertificate_updateBundleName_assertNameUpdate() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        bundle.setBundleName("New Test Bundle Name");
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle updatedBundle = (TrustBundle)this.tbRepo.findById((Object)bundle.getId()).block();
        Assert.assertEquals((Object)"New Test Bundle Name", (Object)updatedBundle.getBundleName());
        Assert.assertEquals((Object)bundle.getBundleURL(), (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)bundle.getRefreshInterval(), (long)updatedBundle.getRefreshInterval());
        Assert.assertNull((Object)updatedBundle.getSigningCertificateData());
    }

    @Test
    public void testUpdateTrustBundleSigningCertificate_updateBundleURL_assertURLUpdate() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        bundle.setBundleURL("http://testBundle/bundle.p7b333");
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle updatedBundle = (TrustBundle)this.tbRepo.findById((Object)bundle.getId()).block();
        Assert.assertEquals((Object)bundle.getBundleName(), (Object)bundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b333", (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)bundle.getRefreshInterval(), (long)updatedBundle.getRefreshInterval());
        Assert.assertNull((Object)updatedBundle.getSigningCertificateData());
    }

    @Test
    public void testUpdateTrustBundleSigningCertificate_updateBundleRefreshInterval_assertIntervalUpdate() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        bundle.setRefreshInterval(7);
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle updatedBundle = (TrustBundle)this.tbRepo.findById((Object)bundle.getId()).block();
        Assert.assertEquals((Object)bundle.getBundleName(), (Object)updatedBundle.getBundleName());
        Assert.assertEquals((Object)bundle.getBundleURL(), (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)7L, (long)updatedBundle.getRefreshInterval());
        Assert.assertNull((Object)updatedBundle.getSigningCertificateData());
    }
}

