/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.TrustBundle;
import reactor.test.StepVerifier;

public class TrustBundleRepositry_getBundlesTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testGetTrustBundles_emptyBundleStore_assertNotBundlesRetrieved() {
        ((StepVerifier.FirstStep)this.tbRepo.findAll().as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testGetTrustBundles_singleEntryInBundleStore_noAnchors_assertBundlesRetrieved() {
        LocalDateTime now = LocalDateTime.now();
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection bundles = (Collection)this.tbRepo.findAll().collectList().block();
        Assert.assertEquals((long)1L, (long)bundles.size());
        TrustBundle addedBundle = (TrustBundle)bundles.iterator().next();
        Assert.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.compareTo(addedBundle.getCreateTime()) <= 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertEquals((long)0L, (long)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
    }

    @Test
    public void testGetTrustBundles_singleEntryInBundleStore_signingCert_noAnchors_assertBundlesRetrieved() throws Exception {
        LocalDateTime now = LocalDateTime.now();
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setSigningCertificateData(TrustBundleRepositry_getBundlesTest.loadCertificateData("secureHealthEmailCACert.der"));
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection bundles = (Collection)this.tbRepo.findAll().collectList().block();
        Assert.assertEquals((long)1L, (long)bundles.size());
        TrustBundle addedBundle = (TrustBundle)bundles.iterator().next();
        Assert.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.compareTo(addedBundle.getCreateTime()) <= 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertEquals((long)0L, (long)addedBundle.getLastRefreshError());
        Assert.assertNotNull((Object)addedBundle.getSigningCertificateData());
        Assert.assertNotNull((Object)addedBundle.toSigningCertificate());
    }

    @Test
    public void testGetTrustBundles_multipeEntriesInBundleStore_noAnchors_assertBundlesRetrieved() {
        LocalDateTime now = LocalDateTime.now();
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle1");
        bundle.setBundleURL("http://testBundle/bundle1.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle2");
        bundle.setBundleURL("http://testBundle/bundle2.p7b");
        bundle.setRefreshInterval(6);
        bundle.setCheckSum("67890");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection bundles = (Collection)this.tbRepo.findAll().collectList().block();
        Assert.assertEquals((long)2L, (long)bundles.size());
        Iterator iter = bundles.iterator();
        TrustBundle addedBundle = (TrustBundle)iter.next();
        Assert.assertEquals((Object)"Test Bundle1", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle1.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.compareTo(addedBundle.getCreateTime()) <= 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertEquals((long)0L, (long)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
        addedBundle = (TrustBundle)iter.next();
        Assert.assertEquals((Object)"Test Bundle2", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle2.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"67890", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)6L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.compareTo(addedBundle.getCreateTime()) <= 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertEquals((long)0L, (long)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
    }
}

