/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.CertPolicyGroupDomainReltn;
import org.nhindirect.config.store.Domain;
import reactor.test.StepVerifier;

public class CertPolicyGroupDomainReltnRepository_associatePolicyGroupToDomainTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testAssociatePolicyGroupToDomain_associateDomainAndGroup_assertAssociationAdded() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroupDomainReltn reltn = new CertPolicyGroupDomainReltn();
        reltn.setPolicyGroupId(group.getId());
        reltn.setDomainId(domain.getId());
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection groupReltn = (Collection)this.reltnRepo.findByDomainId(domain.getId()).collectList().block();
        Assertions.assertEquals((int)1, (int)groupReltn.size());
        reltn = (CertPolicyGroupDomainReltn)groupReltn.iterator().next();
        Assertions.assertEquals((Long)group.getId(), (Long)reltn.getPolicyGroupId());
        Assertions.assertEquals((Long)domain.getId(), (Long)reltn.getDomainId());
    }
}

