/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Collection;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.CertPolicyGroupDomainReltn;
import org.nhindirect.config.store.Domain;
import reactor.test.StepVerifier;

public class CertPolicyGroupDomainReltnRepository_getPolicyGroupDomainReltnsTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicyGroupsDomainReltns_emptyReltnStore_assertNoReltnsRetrieved() {
        ((StepVerifier.FirstStep)this.reltnRepo.findAll().as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testGetPolicyGroupsDomainReltns_singleEntryInReltns_assertReltnRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroupDomainReltn reltn = new CertPolicyGroupDomainReltn();
        reltn.setPolicyGroupId(group.getId());
        reltn.setDomainId(domain.getId());
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection reltns = (Collection)this.reltnRepo.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)reltns.size());
        reltn = (CertPolicyGroupDomainReltn)reltns.iterator().next();
        Assertions.assertEquals((Long)group.getId(), (Long)reltn.getPolicyGroupId());
        Assertions.assertEquals((Long)domain.getId(), (Long)reltn.getDomainId());
    }

    @Test
    public void testGetPolicyGroupsDomainReltns_multipeEntriesReltns_assertReltnsRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group 1");
        CertPolicyGroup group2 = new CertPolicyGroup();
        group2.setPolicyGroupName("Test Group 2");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group2).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroupDomainReltn reltn = new CertPolicyGroupDomainReltn();
        reltn.setPolicyGroupId(group1.getId());
        reltn.setDomainId(domain.getId());
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        reltn = new CertPolicyGroupDomainReltn();
        reltn.setPolicyGroupId(group2.getId());
        reltn.setDomainId(domain.getId());
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection reltns = (Collection)this.reltnRepo.findAll().collectList().block();
        Assertions.assertEquals((int)2, (int)reltns.size());
        Iterator iter = reltns.iterator();
        reltn = (CertPolicyGroupDomainReltn)iter.next();
        Assertions.assertEquals((Long)group1.getId(), (Long)reltn.getPolicyGroupId());
        Assertions.assertEquals((Long)domain.getId(), (Long)reltn.getDomainId());
        reltn = (CertPolicyGroupDomainReltn)iter.next();
        Assertions.assertEquals((Long)group2.getId(), (Long)reltn.getPolicyGroupId());
        Assertions.assertEquals((Long)domain.getId(), (Long)reltn.getDomainId());
    }
}

