/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Collection;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.CertPolicyGroupDomainReltn;
import org.nhindirect.config.store.Domain;
import reactor.test.StepVerifier;

public class CertPolicyGroupDomainReltnRepository_getPolicyGroupsByDomainTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicyGroupsByDomain_associationsExist_assertPoliciesRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroupDomainReltn reltn = new CertPolicyGroupDomainReltn();
        reltn.setPolicyGroupId(group.getId());
        reltn.setDomainId(domain.getId());
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection policies = (Collection)this.reltnRepo.findByDomainId(domain.getId()).collectList().block();
        Assertions.assertEquals((int)1, (int)policies.size());
    }

    @Test
    public void testGetPolicyGroupsByDomain_multipleAssociationsExist_assertPoliciesRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group1");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup group2 = new CertPolicyGroup();
        group2.setPolicyGroupName("Test Group2");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group2).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroupDomainReltn reltn = new CertPolicyGroupDomainReltn();
        reltn.setPolicyGroupId(group1.getId());
        reltn.setDomainId(domain.getId());
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        reltn = new CertPolicyGroupDomainReltn();
        reltn.setPolicyGroupId(group2.getId());
        reltn.setDomainId(domain.getId());
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection policies = (Collection)this.reltnRepo.findByDomainId(domain.getId()).collectList().block();
        Assertions.assertEquals((int)2, (int)policies.size());
        Iterator polIter = policies.iterator();
        Assertions.assertEquals((Long)group1.getId(), (Long)((CertPolicyGroupDomainReltn)polIter.next()).getPolicyGroupId());
        Assertions.assertEquals((Long)group2.getId(), (Long)((CertPolicyGroupDomainReltn)polIter.next()).getPolicyGroupId());
    }

    @Test
    public void testGetPolicyGroupsByDomain_multipleAssociationsExist_oneToEachDomain_assertPoliciesRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain 1");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Domain domain2 = new Domain();
        domain2.setDomainName("Test Domain 2");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain2).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group1");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup group2 = new CertPolicyGroup();
        group2.setPolicyGroupName("Test Group2");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group2).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroupDomainReltn reltn = new CertPolicyGroupDomainReltn();
        reltn.setPolicyGroupId(group1.getId());
        reltn.setDomainId(domain1.getId());
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        reltn = new CertPolicyGroupDomainReltn();
        reltn.setPolicyGroupId(group2.getId());
        reltn.setDomainId(domain2.getId());
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection policies = (Collection)this.reltnRepo.findByDomainId(domain1.getId()).collectList().block();
        Assertions.assertEquals((int)1, (int)policies.size());
        Iterator polIter = policies.iterator();
        Assertions.assertEquals((Long)group1.getId(), (Long)((CertPolicyGroupDomainReltn)polIter.next()).getPolicyGroupId());
        policies = (Collection)this.reltnRepo.findByDomainId(domain2.getId()).collectList().block();
        Assertions.assertEquals((int)1, (int)policies.size());
        polIter = policies.iterator();
        Assertions.assertEquals((Long)group2.getId(), (Long)((CertPolicyGroupDomainReltn)polIter.next()).getPolicyGroupId());
    }

    @Test
    public void testGetPolicyGroupsByDomain_multipleAssociationsExist_policyToMultipeDomains_assertPoliciesRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain 1");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Domain domain2 = new Domain();
        domain2.setDomainName("Test Domain 2");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain2).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group1");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroupDomainReltn reltn = new CertPolicyGroupDomainReltn();
        reltn.setPolicyGroupId(group1.getId());
        reltn.setDomainId(domain1.getId());
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        reltn = new CertPolicyGroupDomainReltn();
        reltn.setPolicyGroupId(group1.getId());
        reltn.setDomainId(domain2.getId());
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection policies = (Collection)this.reltnRepo.findByDomainId(domain1.getId()).collectList().block();
        Assertions.assertEquals((int)1, (int)policies.size());
        Iterator polIter = policies.iterator();
        Assertions.assertEquals((Long)group1.getId(), (Long)((CertPolicyGroupDomainReltn)polIter.next()).getPolicyGroupId());
        policies = (Collection)this.reltnRepo.findByDomainId(domain2.getId()).collectList().block();
        Assertions.assertEquals((int)1, (int)policies.size());
        polIter = policies.iterator();
        Assertions.assertEquals((Long)group1.getId(), (Long)((CertPolicyGroupDomainReltn)polIter.next()).getPolicyGroupId());
    }

    @Test
    public void testGetPolicyGroupsByDomain_noPoliciesInDomain_assertPoliciesNotRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain 1");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection policies = (Collection)this.reltnRepo.findByDomainId(domain1.getId()).collectList().block();
        Assertions.assertEquals((int)0, (int)policies.size());
    }
}

