/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.time.LocalDateTime;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.springframework.dao.DataIntegrityViolationException;
import reactor.test.StepVerifier;

public class CertPolicyGroupRepository_addPolicyGroupTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testAddPolicyGroup_addPolicyGroup_assertAdded() {
        LocalDateTime now = LocalDateTime.now();
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection groups = (Collection)this.groupRepo.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)groups.size());
        CertPolicyGroup addedGroup = (CertPolicyGroup)groups.iterator().next();
        Assertions.assertEquals((Object)group.getPolicyGroupName(), (Object)addedGroup.getPolicyGroupName());
        Assertions.assertTrue((now.compareTo(addedGroup.getCreateTime()) <= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAddPolicyGroup_addExistingPolicy_assertException() {
        Assertions.assertThrows(DataIntegrityViolationException.class, () -> {
            CertPolicyGroup group = new CertPolicyGroup();
            group.setPolicyGroupName("Test Group");
            ((StepVerifier.FirstStep)this.groupRepo.save((Object)group).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
            Collection groups = (Collection)this.groupRepo.findAll().collectList().block();
            Assertions.assertEquals((int)1, (int)groups.size());
            group = new CertPolicyGroup();
            group.setPolicyGroupName("Test Group");
            this.groupRepo.save((Object)group).block();
        });
    }
}

