/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.CertPolicyGroupReltn;
import org.nhindirect.config.store.CertPolicyUse;
import org.nhindirect.policy.PolicyLexicon;
import reactor.test.StepVerifier;

public class CertPolicyGroupRepository_addPolicyUseToGroupTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testAddPolicyToGroup_associatePolicyAndGroup_assertAssociationAdded() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML.ordinal());
        policy.setPolicyData(new byte[]{1, 2, 3});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroupReltn reltn = new CertPolicyGroupReltn();
        reltn.setPolicyId(policy.getId());
        reltn.setPolicyGroupId(group.getId());
        reltn.setPolicyUse(CertPolicyUse.PUBLIC_RESOLVER.ordinal());
        reltn.setIncoming(true);
        reltn.setOutgoing(false);
        ((StepVerifier.FirstStep)this.groupReltRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        List assocGroups = (List)this.groupReltRepo.findByPolicyGroupId(group.getId()).collectList().block();
        Assertions.assertEquals((int)1, (int)assocGroups.size());
        reltn = (CertPolicyGroupReltn)assocGroups.get(0);
        Assertions.assertEquals((Long)policy.getId(), (Long)reltn.getPolicyId());
        Assertions.assertEquals((Long)group.getId(), (Long)reltn.getPolicyGroupId());
        Assertions.assertEquals((int)CertPolicyUse.PUBLIC_RESOLVER.ordinal(), (int)reltn.getPolicyUse());
        Assertions.assertTrue((boolean)reltn.isIncoming());
        Assertions.assertFalse((boolean)reltn.isOutgoing());
    }
}

