/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.time.LocalDateTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import reactor.test.StepVerifier;

public class CertPolicyGroupRepository_getPolicyGroupByIdTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicyGroupById_emptyStore_assertNoPolicyGroupReturned() {
        ((StepVerifier.FirstStep)this.groupRepo.findById((Object)1234L).as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testGetPolicyGroupById_singlePolicyGroupInStore_idNotInStore_assertNoPolicyGroupReturned() {
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        ((StepVerifier.FirstStep)this.groupRepo.findById((Object)1234L).as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testGetPolicyGroupById_singlePolicyGroupInStore_assertPolicyGroupReturned() {
        LocalDateTime now = LocalDateTime.now();
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup addedGroup = (CertPolicyGroup)this.groupRepo.findById((Object)group.getId()).block();
        Assertions.assertEquals((Object)group.getPolicyGroupName(), (Object)addedGroup.getPolicyGroupName());
        Assertions.assertTrue((now.compareTo(addedGroup.getCreateTime()) <= 0 ? 1 : 0) != 0);
    }
}

