/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.time.LocalDateTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import reactor.test.StepVerifier;

public class CertPolicyGroupRepository_getPolicyGroupByNameTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicyGroupByName_emptyStore_assertNoPolicyReturned() {
        ((StepVerifier.FirstStep)this.groupRepo.findByPolicyGroupNameIgnoreCase("Test Group").as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testGetPolicyGroupByName_singlePolicyGroupInStore_nameNotInStore_assertNoPolicyGroupReturned() {
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Assertions.assertNull((Object)this.groupRepo.findByPolicyGroupNameIgnoreCase("Test Group X").block());
    }

    @Test
    public void testGetPolicyGroupByName_singlePolicyGroupInStore_assertPolicyGroupReturned() {
        LocalDateTime now = LocalDateTime.now();
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        ((StepVerifier.FirstStep)this.groupRepo.save((Object)group).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicyGroup addedGroup = (CertPolicyGroup)this.groupRepo.findByPolicyGroupNameIgnoreCase("Test GrouP").block();
        Assertions.assertEquals((Object)group.getPolicyGroupName(), (Object)addedGroup.getPolicyGroupName());
        Assertions.assertTrue((now.compareTo(addedGroup.getCreateTime()) <= 0 ? 1 : 0) != 0);
    }
}

